% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointDTM_get.R
\name{pointDTM_get}
\alias{pointDTM_get}
\title{Get terrain elevation for a given polygon}
\usage{
pointDTM_get(polygon, distance = 1, print_iter = TRUE)
}
\arguments{
\item{polygon}{the polygon layer with only one object
(its area is limited to the 20 ha * distance parameter),
the input coordinate system must be EPSG:2180}

\item{distance}{distance between points in meters
(must be integer and greater than 1)}

\item{print_iter}{print the current iteration of all
(logical, TRUE default)}
}
\value{
a data frame with vector points and terrain elevation
(EPSG:2180, Vertical Reference System:PL-KRON86-NH)
}
\description{
Get terrain elevation for a given polygon
}
\examples{
\dontrun{
library(sf)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)
DTM = pointDTM_get(polygon, distance = 2)
}
}
