\name{gx.md.print}
\alias{gx.md.print}
\title{ Function to Display Membership Probabilities }
\description{
Function to display the Mahalanobis distances (MDs) and predicted probabilities of membership (ppm) following computations by functions \code{\link{gx.md.gait}}, \code{\link{gx.md.gait.closed}}, \code{\link{gx.mva}}, \code{\link{gx.robmva}}, or \code{\link{gx.robmva.closed}}.  The user may select the predicted probability of membership below which the results are displayed.  Optionally the entire generated table may be saved as a \sQuote{csv} file for future use. 
}
\usage{
gx.md.print(save, pcut = 0.1, file = NULL)
}
\arguments{
  \item{save}{ a saved object from any of functions \code{gx.md.gait}, \code{gx.md.gait.closed}, \code{gx.mva}, \code{gx.robmva}, or \code{gx.robmva.closed}. }
  \item{pcut}{ the probabilitity of group membership below which records will be displayed on the current device in ascending order of membership probability, i.e. most outlying individuals first. }
  \item{file}{ the file name for saving the function output in the R working directory, see Details below. }
}
\details{
The Mahanalobis distances, the membership probabilities dataframe, and input matrix row numbers are extracted from the saved object and sorted in increasing order of probabilities of group membership for display on the current device.  The table generated by the function may be saved as a \sQuote{csv} file in the working directory.  Note, the \sQuote{.csv} extension is appended in the function.  See example below.
}
\value{
The last displayed table, \code{table.rows}, is returned and may be saved as an object if required.
}
\note{
This function is similar in purpose to \code{\link{gx.mvalloc.print}} for displaying multivariate outliers, however, it operates on a single population. 
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{gx.md.gait}}, \code{\link{gx.md.gait.closed}}, \code{\link{gx.mva}}, \code{\link{gx.robmva}}, \code{\link{gx.robmva.closed}}, \cr\code{\link{gx.mvalloc}}, \code{\link{gx.mvalloc.print}}. } 
\examples{
## Make test data available
data(sind)
attach(sind)
sind.mat <- as.matrix(sind[, -c(1:3)])
## Ensure all data are in the same units (mg/kg)
sind.mat2open <- sind.mat
sind.mat2open[, 2] <- sind.mat2open[, 2] * 10000

## Estimate and display robust Mahalanobis distances
sind.save <- gx.md.gait.closed(sind.mat2open, mcdstart = TRUE, ifadd = NULL)
gx.md.print(sind.save, pcut = 0.3)

## Save display for future use
gx.md.print(sind.save, file = "sind.save.ilr.mcd.mds")

## Clean-up and detach test data
rm(sind.mat)
rm(sind.mat2open)
rm(sind.save)
detach(sind)
}
\keyword{ print }

