% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platemodel.R
\docType{class}
\name{platemodel-class}
\alias{platemodel-class}
\alias{platemodel}
\alias{initialize,platemodel-method}
\title{Class of objects representing plate tectonic models}
\usage{
\S4method{initialize}{platemodel}(
  .Object,
  rotation = NULL,
  features = NULL,
  name = NULL,
  polygons = NULL
)
}
\arguments{
\item{.Object}{Constructor argument (not needed).}

\item{rotation}{(\code{character}) The path to the rotation file.}

\item{features}{(\code{character}) Named vector of features with the paths to the individual files.}

\item{name}{(\code{character}) (Optional) name of the model.}

\item{polygons}{(\code{character}) (Deprecated) The path to the static plate polygon file.}
}
\value{
A \code{platemodel} class object.
}
\description{
Meta-object containing paths to a unique plate tectonic model
}
\examples{
# path to provided archive
archive <- file.path(
  system.file("extdata", package="rgplates"), 
  "paleomap_v3.zip")
# extract to temporary directory
unzip(archive, exdir=tempdir())
# path to the rotation file
rotPath <- file.path(tempdir(), 
  "PALEOMAP_PlateModel.rot")
# path to the polygons
polPath <- file.path(tempdir(), 
  "PALEOMAP_PlatePolygons.gpml")
# register in R - to be used in reconstruct()
model <- platemodel(rotation=rotPath, features=c("static_polygons"=polPath))
}
