% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platemodel.R
\docType{class}
\name{platemodel-class}
\alias{platemodel-class}
\alias{platemodel}
\alias{initialize,platemodel-method}
\title{Class of objects representing plate tectonic models}
\usage{
\S4method{initialize}{platemodel}(.Object, path = NULL, rotation = NULL, polygons = NULL)
}
\arguments{
\item{.Object}{Constructor argument (not needed).}

\item{path}{(\code{character}) Path to a .mod unique plate model object.}

\item{rotation}{(\code{character}) If \code{path} is \code{NULL}, the path to the rotation file-part of the model.}

\item{polygons}{(\code{character}) If \code{path} is \code{NULL}, the path to the plate polygon file-part of the model.}
}
\value{
A \code{platemodel} class object.
}
\description{
Meta-object containing paths to a unique plate tectonic model
}
\examples{
# path to provided archive
archive <- file.path(
  system.file("extdata", package="rgplates"), 
  "paleomap_v3.zip")
# extract to temporary directory
unzip(archive, exdir=tempdir())
# path to the rotation file
rotPath <- file.path(tempdir(), 
  "PALEOMAP_PlateModel.rot")
# path to the polygons
polPath <- file.path(tempdir(), 
  "PALEOMAP_PlatePolygons.gpml")
# register in R - to be used in reconstruct()
model <- platemodel(rotation=rotPath, polygons=polPath)
}
