% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_count.r
\name{occ_count}
\alias{occ_count}
\title{Get number of occurrence records.}
\usage{
occ_count(
  taxonKey = NULL,
  georeferenced = NULL,
  basisOfRecord = NULL,
  datasetKey = NULL,
  date = NULL,
  typeStatus = NULL,
  country = NULL,
  year = NULL,
  from = 2000,
  to = 2012,
  type = "count",
  publishingCountry = "US",
  protocol = NULL,
  curlopts = list()
)
}
\arguments{
\item{taxonKey}{Species key}

\item{georeferenced}{Return only occurrence records with lat/long data
(\code{TRUE}) or those that don't have that data (\code{FALSE}, default). Note that
you can also get record count with \code{\link[=occ_search]{occ_search()}} by setting \code{limit=0}}

\item{basisOfRecord}{Basis of record}

\item{datasetKey}{Dataset key}

\item{date}{Collection date}

\item{typeStatus}{A type status. See \code{\link[=typestatus]{typestatus()}} dataset for
options}

\item{country}{Country data was collected in, two letter abbreviation. See
\url{http://countrycode.org/} for abbreviations.}

\item{year}{Year data were collected in}

\item{from}{Year to start at}

\item{to}{Year to end at}

\item{type}{One of count (default), schema, basis_of_record, countries, or
year.}

\item{publishingCountry}{Publishing country, two letter ISO country code}

\item{protocol}{Protocol. E.g., 'DWC_ARCHIVE'}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A single numeric value, or a list of numerics.
}
\description{
Get number of occurrence records.
}
\details{
There is a slight difference in the way records are counted here vs.
results from \code{\link[=occ_search]{occ_search()}}. For equivalent outcomes, in the
\code{\link[=occ_search]{occ_search()}} function use \code{hasCoordinate=TRUE}, and
\code{hasGeospatialIssue=FALSE} to have the same outcome for this function
using \code{georeferenced=TRUE}.
}
\section{Supported dimensions}{

That is, there are only a certain set of supported query parameter
combinations that GBIF allows on this API route. They can be found with the
call \code{occ_count(type='schema')}. They are also presented below:

\itemize{
\item basisOfRecord
\item basisOfRecord, country
\item basisOfRecord, country, isGeoreferenced
\item basisOfRecord, country, isGeoreferenced, taxonKey
\item basisOfRecord, country, taxonKey
\item basisOfRecord, datasetKey
\item basisOfRecord, datasetKey, isGeoreferenced
\item basisOfRecord, datasetKey, isGeoreferenced, taxonKey
\item basisOfRecord, datasetKey, taxonKey
\item basisOfRecord, isGeoreferenced, taxonKey
\item basisOfRecord, isGeoreferenced, publishingCountry
\item basisOfRecord, isGeoreferenced, publishingCountry, taxonKey
\item basisOfRecord, publishingCountry
\item basisOfRecord, publishingCountry, taxonKey
\item basisOfRecord, taxonKey
\item country
\item country, datasetKey, isGeoreferenced
\item country, isGeoreferenced
\item country, isGeoreferenced, publishingCountry
\item country, isGeoreferenced, taxonKey
\item country, publishingCountry
\item country, taxonKey
\item country, typeStatus
\item datasetKey
\item datasetKey, isGeoreferenced
\item datasetKey, isGeoreferenced, taxonKey
\item datasetKey, issue
\item datasetKey, taxonKey
\item datasetKey, typeStatus
\item isGeoreferenced
\item isGeoreferenced, publishingCountry
\item isGeoreferenced, publishingCountry, taxonKey
\item isGeoreferenced, taxonKey
\item issue
\item publishingCountry
\item publishingCountry, taxonKey
\item publishingCountry, typeStatus
\item taxonKey
\item taxonKey, typeStatus
\item typeStatus
\item protocol
\item year
}
}

\examples{
\dontrun{
occ_count(basisOfRecord='OBSERVATION')
occ_count(georeferenced=TRUE)
occ_count(country='DE')
occ_count(country='CA', georeferenced=TRUE, basisOfRecord='OBSERVATION')
occ_count(datasetKey='9e7ea106-0bf8-4087-bb61-dfe4f29e0f17')
occ_count(year=2012)
occ_count(taxonKey=2435099)
occ_count(taxonKey=2435099, georeferenced=TRUE)

# Just schema
occ_count(type='schema')

# Counts by basisOfRecord types
occ_count(type='basisOfRecord')

# Counts by basisOfRecord types
occ_count(typeStatus='ALLOTYPE')
occ_count(typeStatus='HOLOTYPE')

# Counts by countries. publishingCountry must be supplied (default to US)
occ_count(type='countries')

# Counts by year. from and to years have to be supplied, default to 2000
# and 2012
occ_count(type='year', from=2000, to=2012)

# Counts by publishingCountry, must supply a country (default to US)
occ_count(type='publishingCountry')
occ_count(type='publishingCountry', country='BZ')

# Pass on curl options
occ_count(type='year', from=2000, to=2012, curlopts = list(verbose = TRUE))
}
}
\references{
\url{http://www.gbif.org/developer/occurrence#metrics}
}
