% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-statistics.R
\docType{methods}
\name{var,ml.col.def-method}
\alias{var,ml.col.def-method}
\title{Variance}
\usage{
\S4method{var}{ml.col.def}(x, na.rm = FALSE)
}
\arguments{
\item{x}{a ml.data.frame field.}

\item{na.rm}{not used currently}
}
\value{
The sample variance
}
\description{
Returns the sample variance of a \link{ml.data.frame} field.
}
\details{
The function returns a empty value if the number of rows of the ml.data.frame
that x belongs to is less than 2.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(locConn, collection = "iris")
 # return the variance
 var(mlIris$Sepal.Length)
}
}

