% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-table-customer-2.R
\name{rfm_table_customer_2}
\alias{rfm_table_customer_2}
\title{RFM table 2 (customer data)}
\usage{
rfm_table_customer_2(
  data = NULL,
  customer_id = NULL,
  n_transactions = NULL,
  latest_visit_date = NULL,
  total_revenue = NULL,
  analysis_date = NULL,
  recency_bins = 5,
  frequency_bins = 5,
  monetary_bins = 5,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{customer_id}{Unique id of the customer.}

\item{n_transactions}{Number of transactions/orders.}

\item{latest_visit_date}{Date of the latest visit.}

\item{total_revenue}{Total revenue from the customer.}

\item{analysis_date}{Date of analysis.}

\item{recency_bins}{Number of bins for recency or custom threshold.}

\item{frequency_bins}{Number of bins for frequency or custom threshold.}

\item{monetary_bins}{Number of bins for monetary or custom threshold.}

\item{...}{Other arguments.}
}
\value{
\code{rfm_table_order} returns a list with the following:

\item{rfm}{RFM table.}
\item{analysis_date}{Date of analysis.}
\item{frequency_bins}{Number of bins used for frequency score.}
\item{recency_bins}{Number of bins used for recency score.}
\item{monetary_bins}{Number of bins used for monetary score.}
\item{threshold}{tibble with thresholds used for generating RFM scores.}
}
\description{
Recency, frequency, monetary and RFM score.
}
\examples{
analysis_date <- lubridate::as_date('2007-01-01')
rfm_table_customer_2(rfm_data_customer, customer_id, number_of_orders,
most_recent_visit, revenue, analysis_date)

# access rfm table
result <- rfm_table_customer_2(rfm_data_customer, customer_id, number_of_orders,
most_recent_visit, revenue, analysis_date)
result$rfm

# using custom threshold 
rfm_table_customer_2(rfm_data_customer, customer_id, number_of_orders,
most_recent_visit, revenue, analysis_date, recency_bins = c(115, 181, 297, 482), 
frequency_bins = c(4, 5, 6, 8), monetary_bins = c(256, 382, 506, 666))

}
