% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fishdraw.R
\name{fish_draw}
\alias{fish_draw}
\title{Automatically generated fish drawings via ggplot2}
\usage{
fish_draw(data = NULL, x = x, y = y, group = group, ...)
}
\arguments{
\item{data}{Path for *.json via \code{\link{get_polylines}}.}

\item{x}{see \code{\link{aes}} for details}

\item{y}{see \code{\link{aes}} for details}

\item{group}{see \code{\link{aes}} for details}

\item{...}{see \code{\link{geom_path}} for details}
}
\value{
ggplot object.
}
\description{
Automatically generated fish drawings via ggplot2
}
\examples{
\dontrun{
# fish drawings via plot
file <- system.file("extdata",package = "rfishdraw")
dat <- readRDS(paste0(file,"/","output_json.rds"))
for (i in seq(length(dat))) {
dat[[i]] <- cbind(dat[[i]],i)
}
plot(NA, xlim = c(0,520),ylim = c(-320,0),axes = F,xlab = " ",ylab = " ")
for(i in seq(length(dat))) {
  lines(x = dat[[i]][,1],y = -dat[[i]][,2], lwd=2, col = "blue")
}

# fish drawings via ggplot2
fish_draw()
}
}
\author{
Liuyong Ding \email{ly_ding@126.com}
}
