% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/proximity.plot.r
\name{proximity.plot}
\alias{proximity.plot}
\title{Plot Random Forest Proximity Scores.}
\usage{
proximity.plot(rf, dim.x = 1, dim.y = 2, legend.loc = NULL,
  grp.cols = NULL, circle.size = 4)
}
\arguments{
\item{rf}{A \code{randomForest} object.}

\item{dim.x,dim.y}{Numeric values giving x and y dimensions to plot from multidimensional scaling of proximity scores.}

\item{legend.loc}{Character keyword specifying location of legend. See \link{legend}.}

\item{grp.cols}{Character vector specifying colors for classes.}

\item{circle.size}{Size of circles around correctly classified points as argument to 'cex'. Set to NULL for no circles.}
}
\description{
Create a plot of Random Forest proximity scores using multi-dimensional scaling.
}
\details{
Produces a scatter plot of proximity scores for \code{dim.x} and \code{dim.y}
dimensions from a multidimensional scale (MDS) conversion of proximity scores from a
\code{randomForest} object. A convex hull is drawn around the a-priori classes.
}
\examples{
data(iris)
iris.rf <- randomForest(Species ~ ., data = iris, importance = TRUE, proximity = TRUE)
iris.rf
proximity.plot(iris.rf, legend.loc = "topleft")
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

