% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_extendr.R
\name{register_extendr}
\alias{register_extendr}
\title{Register the extendr module of a package with R}
\usage{
register_extendr(path = ".", quiet = FALSE, force = FALSE, compile = NA)
}
\arguments{
\item{path}{Path from which package root is looked up.}

\item{quiet}{Logical indicating whether any progress messages should be
generated or not.}

\item{force}{Logical indicating whether to force re-generating
\code{R/extendr-wrappers.R} even when it doesn't seem to need updated. (By
default, generation is skipped when it's newer than the DLL).}

\item{compile}{Logical indicating whether to recompile DLLs:
\describe{
\item{\code{TRUE}}{always recompiles}
\item{\code{NA}}{recompiles if needed (i.e., any source files or manifest file are newer than the DLL)}
\item{\code{FALSE}}{never recompiles}
}}
}
\value{
(Invisibly) Path to the file containing generated wrappers.
}
\description{
This function generates wrapper code corresponding to the extendr module
for an R package. This is useful in package development, where we generally
want appropriate R code wrapping the Rust functions implemented via extendr.
In most development settings, you will not want to call this function directly,
but instead call \code{rextendr::document()}.
}
\details{
The function \code{register_extendr()} compiles the package Rust code if
required, and then the wrapper code is retrieved from the compiled
Rust code and saved into \code{R/extendr-wrappers.R}. Afterwards, you will have
to re-document and then re-install the package for the wrapper functions to
take effect.
}
\seealso{
\code{\link[=document]{document()}}
}
