% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lookarounds.R
\name{lookarounds}
\alias{\%if_next_is\%}
\alias{\%if_next_isnt\%}
\alias{\%if_prev_is\%}
\alias{\%if_prev_isnt\%}
\alias{lookarounds}
\title{Lookarounds}
\usage{
x \%if_next_is\% y

x \%if_next_isnt\% y

x \%if_prev_is\% y

x \%if_prev_isnt\% y
}
\arguments{
\item{x}{A regex pattern.}

\item{y}{A regex pattern.}
}
\description{
Lookarounds
}
\details{
These functions provide an interface to perl lookarounds.

Special binary functions are used to infer an ordering, since often you
might wish to match a word / set of characters conditional on the start
and end of that word.

\itemize{
  \item \code{\%if_next_is\%}: \code{TRUE} if x follows y
  \item \code{\%if_next_isnt\%}: \code{TRUE} if x does not follow y
  \item \code{\%if_prev_is\%}: \code{TRUE} if y comes before x
  \item \code{\%if_prev_isnt\%}: \code{TRUE} if y does not come before x
}
}
\examples{
stopifnot(grepl(rex("crab" \%if_next_is\% "apple"), "crabapple", perl = TRUE))
stopifnot(grepl(rex("crab" \%if_prev_is\% "apple"), "applecrab", perl = TRUE))
stopifnot(grepl(rex(range("a", "e") \%if_next_isnt\% range("f", "g")),
  "ah", perl = TRUE))
stopifnot(grepl(rex(range("a", "e") \%if_next_is\% range("f", "i")),
  "ah", perl = TRUE))
}
\seealso{
Perl 5 Documentation \url{http://perldoc.perl.org/perlre.html#Extended-Patterns}

Other rex: \code{\link{.}}, \code{\link{capture}},
  \code{\link{capture_group}}; \code{\link{:}},
  \code{\link{any_of}}, \code{\link{character_class}},
  \code{\link{except}}, \code{\link{except_any_of}},
  \code{\link{except_some_of}},
  \code{\link{exclude_range}}, \code{\link{none_of}},
  \code{\link{one_of}}, \code{\link{range}},
  \code{\link{some_of}}; \code{\link{\%or\%}},
  \code{\link{or}}; \code{\link{at_least}},
  \code{\link{at_most}}, \code{\link{between}},
  \code{\link{counts}}, \code{\link{n}},
  \code{\link{n_times}}; \code{\link{group}};
  \code{\link{maybe}}, \code{\link{one_or_more}},
  \code{\link{wildcards}}, \code{\link{zero_or_more}},
  \code{\link{zero_or_one}}; \code{\link{not}};
  \code{\link{rex}}, \code{\link{rex_}};
  \code{\link{shortcuts}}
}

