% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eutil.R, R/epost.R, R/esearch.R
\docType{methods}
\name{querykey}
\alias{querykey}
\alias{querykey,entrez_uid-method}
\alias{querykey,epost-method}
\alias{querykey,esearch-method}
\title{querykey}
\usage{
querykey(x, ...)

\S4method{querykey}{epost}(x, ...)

\S4method{querykey}{entrez_uid}(x, ...)

\S4method{querykey}{esearch}(x, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{eutil}} object.}

\item{...}{Further arguments passed on to methods.}
}
\value{
An integer or \code{NA}.
}
\description{
An integer query key returned by an ESearch, EPost or ELink call if
the History server was used. Otherwise \code{NA}.
}
\section{Methods (by class)}{
\itemize{
\item \code{epost}: Retrieve the querykey from an \code{epost} object.

\item \code{entrez_uid}: Retrieve the querykey from an \code{entrez_uid} object.

\item \code{esearch}: Retrieve the querykey from an \code{esearch} object.
}}
\examples{
\dontrun{
e <- esearch("Mus musculus", "taxonomy", usehistory = TRUE)
querykey(e)
}
}
\seealso{
\code{\link{einfo}}, \code{\link{esearch}}, \code{\link{esummary}},
   \code{\link{efetch}}, \code{\link{elink}}, \code{\link{epost}},
   \code{\link{egquery}}, \code{\link{espell}}, \code{\link{ecitmatch}}.
}

