% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_hypothesis_tests.R
\name{retro_design_closed_form}
\alias{retro_design_closed_form}
\title{retro_design_closed_form: Calculates Power, Type S, and Type M error}
\usage{
retro_design_closed_form(A, s, alpha = 0.05)
}
\arguments{
\item{A}{a numeric or list, an estimate of the true effect size}

\item{s}{a numeric, standard error of the estimate}

\item{alpha}{a numeric, the statistical significance threshold}
}
\value{
either a list of length 3 containing the power, type s, and type M
error, or if A is a list, a df that is 4 by length(A), with an effect size
and it's corresponding power, type s, and type m errors in each row.
}
\description{
Calculates Power, Type S, and Type M error and returns them in a list or
df, depending on whether a single true effect size or range is provided.
Uses the closed form solution found for the Type-M error found by Lu et al.
(2018), and thus is faster than retrodesign. For t distributions, use
retrodesign() instead; the closed form solution only applies in the normal
case.
}
\examples{
retrodesign(1,3.28)
retrodesign(list(.2,2,20),8.1)
}
