% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReconstructedCountSet.R
\name{ReconstructedCountSet}
\alias{ReconstructedCountSet}
\title{Class containing functions and data to map \link{CountSet}s to
\link{ReconstructedOutline}s}
\description{
A ReconstructedCountSet contains information about
  features located on \code{\link{ReconstructedOutline}}s. Each
  ReconstructedCountSet contains a list of matrices, each of which
  has columns labelled \code{phi} (latitude) and \code{lambda}
  (longitude) describing the spherical coordinates of points on
  the ReconstructedOutline, and a column \code{C} representing the
  counts at these points.
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:FeatureSetCommon]{retistruct::FeatureSetCommon}} -> \code{\link[retistruct:ReconstructedFeatureSet]{retistruct::ReconstructedFeatureSet}} -> \code{ReconstructedCountSet}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{KR}}{Kernel regression}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReconstructedCountSet-new}{\code{ReconstructedCountSet$new()}}
\item \href{#method-ReconstructedCountSet-getKR}{\code{ReconstructedCountSet$getKR()}}
\item \href{#method-ReconstructedCountSet-clone}{\code{ReconstructedCountSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getCol"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getCol'><code>retistruct::FeatureSetCommon$getCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeature"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeature'><code>retistruct::FeatureSetCommon$getFeature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeatures"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeatures'><code>retistruct::FeatureSetCommon$getFeatures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIDs"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIDs'><code>retistruct::FeatureSetCommon$getIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIndex"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIndex'><code>retistruct::FeatureSetCommon$getIndex()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="setID"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-setID'><code>retistruct::FeatureSetCommon$setID()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedCountSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedCountSet-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedCountSet$new(fs = NULL, ro = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fs}}{\code{\link{FeatureSet}} to reconstruct}

\item{\code{ro}}{\code{\link{ReconstructedOutline}} to which feature
set should be mapped}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedCountSet-getKR"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedCountSet-getKR}{}}}
\subsection{Method \code{getKR()}}{
Get kernel regression estimate of grouped data points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedCountSet$getKR()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Kernel regression computed using
   \code{\link{compute.kernel.estimate}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedCountSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedCountSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedCountSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
