% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathOutline.R
\name{PathOutline}
\alias{PathOutline}
\title{Add point correspondences to the outline}
\value{
To the \code{\link{Outline}} object this adds
\item{\code{hf}}{point correspondence mapping in forward direction for
points on boundary}
\item{\code{hb}}{point correspondence mapping in backward direction for
points on boundary}
}
\description{
Add point correspondences to the outline

Add point correspondences to the outline
}
\details{
The member function \code{stitchSubpaths()} stitches together two
subpaths of the outline. One subpath is stitched in the forward
direction from the point indexed by \code{VF0} to the point
indexed by \code{VF1}. The other is stitched in the backward
direction from \code{VB0} to \code{VB1}. Each point in the subpath
is linked to points in the opposing pathway at an equal or
near-equal fraction along. If a point exists in the opposing
pathway within a distance \code{epsilon} of the projection, this
point is connected. If no point exists within this tolerance, a
new point is created.
}
\section{Super classes}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{\link[retistruct:Outline]{retistruct::Outline}} -> \code{PathOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hf}}{Forward correspondences}

\item{\code{hb}}{Backward correspondences}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-addPoints}{\code{PathOutline$addPoints()}}
\item \href{#method-nextPoint}{\code{PathOutline$nextPoint()}}
\item \href{#method-insertPoint}{\code{PathOutline$insertPoint()}}
\item \href{#method-stitchSubpaths}{\code{PathOutline$stitchSubpaths()}}
\item \href{#method-clone}{\code{PathOutline$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-clearFeatureSets}{\code{retistruct::OutlineCommon$clearFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSet">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSet}{\code{retistruct::OutlineCommon$getFeatureSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSets}{\code{retistruct::OutlineCommon$getFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSetTypes}{\code{retistruct::OutlineCommon$getFeatureSetTypes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs">}\href{../../retistruct/html/OutlineCommon.html#method-getIDs}{\code{retistruct::OutlineCommon$getIDs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="addFeatureSet">}\href{../../retistruct/html/Outline.html#method-addFeatureSet}{\code{retistruct::Outline$addFeatureSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getImage">}\href{../../retistruct/html/Outline.html#method-getImage}{\code{retistruct::Outline$getImage()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineLengths">}\href{../../retistruct/html/Outline.html#method-getOutlineLengths}{\code{retistruct::Outline$getOutlineLengths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineSet">}\href{../../retistruct/html/Outline.html#method-getOutlineSet}{\code{retistruct::Outline$getOutlineSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPoints">}\href{../../retistruct/html/Outline.html#method-getPoints}{\code{retistruct::Outline$getPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPointsScaled">}\href{../../retistruct/html/Outline.html#method-getPointsScaled}{\code{retistruct::Outline$getPointsScaled()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getRimSet">}\href{../../retistruct/html/Outline.html#method-getRimSet}{\code{retistruct::Outline$getRimSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="initialize">}\href{../../retistruct/html/Outline.html#method-initialize}{\code{retistruct::Outline$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapFragment">}\href{../../retistruct/html/Outline.html#method-mapFragment}{\code{retistruct::Outline$mapFragment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapPids">}\href{../../retistruct/html/Outline.html#method-mapPids}{\code{retistruct::Outline$mapPids()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="replaceImage">}\href{../../retistruct/html/Outline.html#method-replaceImage}{\code{retistruct::Outline$replaceImage()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addPoints"></a>}}
\subsection{Method \code{addPoints()}}{
Add points to the outline register of points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$addPoints(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{2 column matrix of points to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The ID of each added point in the register. If points already
  exist a point will not be created in the register,
  but an ID will be returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nextPoint"></a>}}
\subsection{Method \code{nextPoint()}}{
Get next point in path for
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$nextPoint(pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{Point IDs of points to get next position}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-insertPoint"></a>}}
\subsection{Method \code{insertPoint()}}{
Insert point at a fractional distance between points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$insertPoint(i0, i1, f)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i0}}{Point ID of first point}

\item{\code{i1}}{Point ID of second point}

\item{\code{f}}{Fraction of distance  between points \code{i0} and
\code{i1} at which to insert point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stitchSubpaths"></a>}}
\subsection{Method \code{stitchSubpaths()}}{
Stitch subpaths
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$stitchSubpaths(VF0, VF1, VB0, VB1, epsilon)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{VF0}}{First vertex of \dQuote{forward} subpath}

\item{\code{VF1}}{Second vertex of \dQuote{forward} subpath}

\item{\code{VB0}}{First vertex of \dQuote{backward} subpath}

\item{\code{VB1}}{Second vertex of \dQuote{backward} subpath}

\item{\code{epsilon}}{Minimum distance between points}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
