% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{py_eval}
\alias{py_eval}
\title{Evaluate a Python Expression}
\usage{
py_eval(code, convert = TRUE)
}
\arguments{
\item{code}{A single Python expression.}

\item{convert}{Boolean; automatically convert Python objects to R?}
}
\value{
The result produced by evaluating \code{code}, converted to an \code{R}
object when \code{convert} is set to \code{TRUE}.
}
\description{
Evaluate a single Python expression, in a way analogous to the Python
\code{eval()} built-in function.
}
\section{Caveats}{


\code{py_eval()} only supports evaluation of 'simple' Python expressions.
Other expressions (e.g. assignments) will fail; e.g.\preformatted{> py_eval("x = 1")
Error in py_eval_impl(code, convert) : 
  SyntaxError: invalid syntax (reticulate_eval, line 1)
}

and this mirrors what one would see in a regular Python interpreter:\preformatted{>>> eval("x = 1")
Traceback (most recent call last):
  File "<stdin>", line 1, in <module>
  File "<string>", line 1
x = 1
^
  SyntaxError: invalid syntax
}

The \code{\link[=py_run_string]{py_run_string()}} method can be used if the evaluation of arbitrary
Python code is required.
}

