% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{py_get_item}
\alias{py_get_item}
\title{Get an item from a Python object}
\usage{
py_get_item(x, key, silent = FALSE)
}
\arguments{
\item{x}{A Python object.}

\item{key}{The key used for item lookup.}

\item{silent}{Boolean; when \code{TRUE}, attempts to access
missing items will return \code{NULL} rather than
throw an error.}
}
\description{
Retrieve an item from a Python object, similar to how
\code{x[name]} might be used in Python code to access an
item indexed by \code{key} on an object \code{x}. The object's
\code{__getitem__} method will be called.
}
\seealso{
Other item-related APIs: \code{\link{py_del_item}},
  \code{\link{py_set_item}}
}
\concept{item-related APIs}
