% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nb_patches_constraint.R
\name{add_nb_patches_constraint}
\alias{add_nb_patches_constraint}
\title{Add constraint to limit the number of patches (habitat + restoration)}
\usage{
add_nb_patches_constraint(problem, min_nb_patches, max_nb_patches)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{min_nb_patches}{\code{integer} Minimum number of patches.}

\item{max_nb_patches}{\code{integer} Maximum number of patches.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Add constraint to a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object
to specify the number of patches (habitat + restoration) that can be
present within a solution.
}
\details{
A patch is a spatially continuous set of habitat and restoration
planning units. This constraints applies on the union of the set of planning
units that are selected for restoration and the initial habitat patches,
and allows to specify a minimum and maximum number of patches. In practice,
this constraint is useful to set simple targets for structural connectivity.
}
\examples{
\dontrun{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  add_restorable_constraint(
    min_restore = 10,
    max_restore = 100,
  ) \%>\%
  add_nb_patches_constraint(1, 1)

# plot preprocessed data
plot(rast(list(p$data$existing_habitat, p$data$restorable_habitat)), nc = 2)

# print problem
print(p)

# Solve problem
s <- solve(p)
# plot solution
plot(s)
}

}
\seealso{
Other constraints: 
\code{\link{add_available_areas_constraint}()},
\code{\link{add_compactness_constraint}()},
\code{\link{add_components_constraint}()},
\code{\link{add_connected_constraint}()},
\code{\link{add_locked_out_constraint}()},
\code{\link{add_min_iic_constraint}()},
\code{\link{add_min_mesh_constraint}()},
\code{\link{add_no_new_patch_constraint}()},
\code{\link{add_restorable_constraint}()}
}
\concept{constraints}
