/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.algo;

import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;
import org.chocosolver.util.tools.MathUtils;

public class AlgoAllDiffBC {
    private boolean weakReason;
    private int[] t;
    private int[] d;
    private int[] h;
    private int[] bounds;
    private int nbBounds;
    private Interval[] intervals;
    private int[] minsorted;
    private int[] maxsorted;
    private int[] bucket;
    private IntComparator minComp;
    private IntComparator maxComp;
    private final Propagator<?> aCause;
    private IntVar[] vars;
    private ArraySort<Interval> sorter;

    public AlgoAllDiffBC(Propagator<?> cause) {
        this.aCause = cause;
    }

    public void reset(IntVar[] variables) {
        int i;
        this.vars = variables;
        int n = this.vars.length;
        boolean allEnum = true;
        if (this.intervals == null || this.intervals.length < n) {
            this.t = new int[2 * n + 2];
            this.d = new int[2 * n + 2];
            this.h = new int[2 * n + 2];
            this.bounds = new int[2 * n + 2];
            this.intervals = new Interval[n];
            this.minsorted = new int[n];
            this.maxsorted = new int[n];
            this.bucket = new int[2 * n + 2];
            for (i = 0; i < n; ++i) {
                this.intervals[i] = new Interval();
                allEnum &= this.vars[i].hasEnumeratedDomain();
            }
            this.sorter = new ArraySort(n, false, true);
            this.weakReason = true;
        }
        for (i = 0; i < n; ++i) {
            this.minsorted[i] = i;
            this.maxsorted[i] = i;
        }
        this.minComp = (i1, i2) -> MathUtils.safeSubstract(this.intervals[i1].lb, this.intervals[i2].lb);
        this.maxComp = (i1, i2) -> MathUtils.safeSubstract(this.intervals[i1].ub, this.intervals[i2].ub);
    }

    public boolean filter() throws ContradictionException {
        boolean again;
        boolean hasFiltered = false;
        do {
            this.sortIt();
            again = this.filterLower();
            hasFiltered |= (again |= this.filterUpper());
        } while (again);
        return hasFiltered;
    }

    private void sortIt() {
        int n = this.vars.length;
        for (int i = 0; i < n; ++i) {
            IntVar vt = this.vars[i];
            this.intervals[i].lb = vt.getLB();
            this.intervals[i].ub = vt.getUB() + 1;
        }
        this.sorter.sort(this.minsorted, n, this.minComp);
        this.sorter.sort(this.maxsorted, n, this.maxComp);
        int min = this.intervals[this.minsorted[0]].lb;
        int max = this.intervals[this.maxsorted[0]].ub;
        int last = min - 2;
        int nb = 0;
        this.bounds[0] = last;
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.vars.length && min <= max) {
                if (min != last) {
                    this.bounds[++nb] = last = min;
                }
                this.intervals[this.minsorted[i]].minrank = nb;
                if (++i >= this.vars.length) continue;
                min = this.intervals[this.minsorted[i]].lb;
                continue;
            }
            if (max != last) {
                this.bounds[++nb] = last = max;
            }
            this.intervals[this.maxsorted[j]].maxrank = nb;
            if (++j == this.vars.length) break;
            max = this.intervals[this.maxsorted[j]].ub;
        }
        this.nbBounds = nb;
        this.bounds[nb + 1] = this.bounds[nb] + 2;
    }

    private void pathset(int[] tab, int start, int end, int to) {
        int next;
        int prev = next = start;
        while (prev != end) {
            next = tab[prev];
            tab[prev] = to;
            prev = next;
        }
    }

    private int pathmin(int[] tab, int i) {
        while (tab[i] < i) {
            i = tab[i];
        }
        return i;
    }

    private int pathmax(int[] tab, int i) {
        while (tab[i] > i) {
            i = tab[i];
        }
        return i;
    }

    private boolean filterLower() throws ContradictionException {
        int i;
        boolean filter = false;
        for (i = 1; i <= this.nbBounds + 1; ++i) {
            this.t[i] = this.h[i] = i - 1;
            this.d[i] = this.bounds[i] - this.bounds[i - 1];
            this.bucket[i] = -1;
        }
        for (i = 0; i < this.vars.length; ++i) {
            int minrank = this.intervals[this.maxsorted[i]].minrank;
            int maxrank = this.intervals[this.maxsorted[i]].maxrank;
            int z = this.pathmax(this.t, minrank + 1);
            int j = this.t[z];
            this.intervals[this.maxsorted[i]].next = this.bucket[z];
            this.bucket[z] = this.maxsorted[i];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z + 1;
                z = this.pathmax(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, minrank + 1, z, z);
            if (this.d[z] < this.bounds[z] - this.bounds[maxrank] && !this.aCause.getModel().getSolver().isLCG()) {
                this.aCause.fails();
            }
            if (this.h[minrank] > minrank) {
                int w = this.pathmax(this.h, this.h[minrank]);
                int hall_max = this.bounds[w];
                if (this.vars[this.maxsorted[i]].updateLowerBound(hall_max, this.aCause, this.explainLower(this.bounds[minrank], hall_max, w, i))) {
                    filter = true;
                    this.intervals[this.maxsorted[i]].lb = hall_max;
                }
                this.pathset(this.h, minrank, w, w);
            }
            if (this.d[z] != this.bounds[z] - this.bounds[maxrank]) continue;
            this.pathset(this.h, this.h[maxrank], j - 1, maxrank);
            this.h[maxrank] = j - 1;
        }
        return filter;
    }

    private Reason explainLower(int hall_min, int hall_max, int w, int i) {
        if (this.aCause.getModel().getSettings().isLCG()) {
            int k = w;
            while (this.bounds[k] > hall_min) {
                int l = this.bucket[k];
                while (l >= 0) {
                    hall_min = Math.min(hall_min, this.intervals[l].lb);
                    l = this.intervals[l].next;
                }
                --k;
            }
            int[] ps = new int[2 + (hall_max - hall_min) * 2];
            int m = 1;
            if (this.weakReason) {
                ps[m++] = this.vars[this.maxsorted[i]].getMinLit();
                int k2 = w;
                while (this.bounds[k2] > hall_min) {
                    int l = this.bucket[k2];
                    while (l >= 0) {
                        ps[m++] = this.vars[l].getMinLit();
                        ps[m++] = this.vars[l].getMaxLit();
                        l = this.intervals[l].next;
                    }
                    --k2;
                }
            } else {
                ps[m++] = MiniSat.neg(this.vars[this.maxsorted[i]].getLit(hall_min, 2));
                int k3 = w;
                while (this.bounds[k3] > hall_min) {
                    int l = this.bucket[k3];
                    while (l >= 0) {
                        ps[m++] = MiniSat.neg(this.vars[l].getLit(hall_min, 2));
                        ps[m++] = MiniSat.neg(this.vars[l].getLit(hall_max - 1, 3));
                        l = this.intervals[l].next;
                    }
                    --k3;
                }
            }
            return Reason.r(ps);
        }
        return Reason.undef();
    }

    private boolean filterUpper() throws ContradictionException {
        int i;
        boolean filter = false;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.t[i] = this.h[i] = i + 1;
            this.d[i] = this.bounds[i + 1] - this.bounds[i];
            this.bucket[i] = -1;
        }
        for (i = this.vars.length - 1; i >= 0; --i) {
            int maxrank = this.intervals[this.minsorted[i]].maxrank;
            int minrank = this.intervals[this.minsorted[i]].minrank;
            int z = this.pathmin(this.t, maxrank - 1);
            this.intervals[this.minsorted[i]].next = this.bucket[z];
            this.bucket[z] = this.minsorted[i];
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z - 1;
                z = this.pathmin(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, maxrank - 1, z, z);
            if (this.d[z] < this.bounds[minrank] - this.bounds[z] && !this.aCause.getModel().getSolver().isLCG()) {
                this.aCause.fails();
            }
            if (this.h[maxrank] < maxrank) {
                int w = this.pathmin(this.h, this.h[maxrank]);
                int hall_min = this.bounds[w];
                if (this.vars[this.minsorted[i]].updateUpperBound(hall_min - 1, this.aCause, this.explainUpper(hall_min, this.bounds[maxrank], w, i))) {
                    filter = true;
                    this.intervals[this.minsorted[i]].ub = hall_min;
                }
                this.pathset(this.h, maxrank, w, w);
            }
            if (this.d[z] != this.bounds[minrank] - this.bounds[z]) continue;
            this.pathset(this.h, this.h[minrank], j + 1, minrank);
            this.h[minrank] = j + 1;
        }
        return filter;
    }

    private Reason explainUpper(int hall_min, int hall_max, int w, int i) {
        if (this.aCause.getModel().getSettings().isLCG()) {
            int k = w;
            while (this.bounds[k] < hall_max) {
                int l = this.bucket[k];
                while (l >= 0) {
                    hall_max = Math.max(hall_max, this.intervals[l].ub);
                    l = this.intervals[l].next;
                }
                ++k;
            }
            int[] ps = new int[2 + (hall_max - hall_min) * 2];
            int m = 1;
            if (this.weakReason) {
                ps[m++] = this.vars[this.minsorted[i]].getMaxLit();
                int k2 = w;
                while (this.bounds[k2] < hall_max) {
                    int l = this.bucket[k2];
                    while (l >= 0) {
                        ps[m++] = this.vars[l].getMinLit();
                        ps[m++] = this.vars[l].getMaxLit();
                        l = this.intervals[l].next;
                    }
                    ++k2;
                }
            } else {
                ps[m++] = MiniSat.neg(this.vars[this.minsorted[i]].getLit(hall_max - 1, 3));
                int k3 = w;
                while (this.bounds[k3] < hall_max) {
                    int l = this.bucket[k3];
                    while (l >= 0) {
                        ps[m++] = MiniSat.neg(this.vars[l].getLit(hall_min, 2));
                        ps[m++] = MiniSat.neg(this.vars[l].getLit(hall_max - 1, 3));
                        l = this.intervals[l].next;
                    }
                    ++k3;
                }
            }
            return Reason.r(ps);
        }
        return Reason.undef();
    }

    private static class Interval {
        private int minrank;
        private int maxrank;
        private int lb;
        private int ub;
        private int next;

        private Interval() {
        }
    }
}

