/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.PropCompactTable;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.procedure.UnaryIntProcedure;

public class PropCompactTableStar
extends PropCompactTable {
    private long[][][] inc_supports;

    public PropCompactTableStar(IntVar[] vars, Tuples tuples) {
        super(vars, tuples);
        assert (tuples.allowUniversalValue());
    }

    @Override
    protected UnaryIntProcedure<Integer> makeProcedure() {
        return new UnaryIntProcedure<Integer>(){
            int var;
            int off;

            @Override
            public UnaryIntProcedure set(Integer o) {
                this.var = o;
                this.off = PropCompactTableStar.this.offset[this.var];
                return this;
            }

            @Override
            public void execute(int i) throws ContradictionException {
                PropCompactTableStar.this.currTable.addToMask(PropCompactTableStar.this.inc_supports[this.var][i - this.off]);
            }
        };
    }

    @Override
    protected void computeSupports(Tuples tuples) {
        int n = ((IntVar[])this.vars).length;
        this.offset = new int[n];
        this.supports = new long[n][][];
        this.inc_supports = new long[n][][];
        this.residues = new int[n][];
        for (int i = 0; i < n; ++i) {
            int lb = ((IntVar[])this.vars)[i].getLB();
            int ub = ((IntVar[])this.vars)[i].getUB();
            this.offset[i] = lb;
            this.supports[i] = new long[ub - lb + 1][this.currTable.words.length];
            this.inc_supports[i] = new long[ub - lb + 1][this.currTable.words.length];
            this.residues[i] = new int[ub - lb + 1];
        }
        int wI = 0;
        int bI = 63;
        int star = tuples.getStarValue();
        block1: for (int ti = 0; ti < tuples.nbTuples(); ++ti) {
            int[] tuple = tuples.get(ti);
            for (int i = 0; i < tuple.length; ++i) {
                if (!((IntVar[])this.vars)[i].contains(tuple[i]) && tuple[i] != star) continue block1;
            }
            long index = 1L << bI;
            for (int i = 0; i < tuple.length; ++i) {
                int val = tuple[i];
                if (val != star) {
                    long[] lArray = this.supports[i][val - this.offset[i]];
                    int n2 = wI;
                    lArray[n2] = lArray[n2] | index;
                    long[] lArray2 = this.inc_supports[i][val - this.offset[i]];
                    int n3 = wI;
                    lArray2[n3] = lArray2[n3] | index;
                    continue;
                }
                int u = this.supports[i].length + this.offset[i];
                val = this.offset[i];
                while (val <= u) {
                    long[] lArray = this.supports[i][val - this.offset[i]];
                    int n4 = wI;
                    lArray[n4] = lArray[n4] | index;
                    val = ((IntVar[])this.vars)[i].nextValue(val);
                }
            }
            if ((bI = (int)((byte)(bI - 1))) >= 0) continue;
            bI = 63;
            ++wI;
        }
    }
}

