/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.UpdatablePropagator;
import org.chocosolver.solver.constraints.nary.lex.PropLexInt;
import org.chocosolver.solver.constraints.unary.Member;
import org.chocosolver.solver.constraints.unary.NotMember;
import org.chocosolver.solver.objective.ParetoMaximizer;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.criteria.Criterion;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public interface IResolutionHelper
extends ISelf<Solver> {
    default public Solution findSolution(Criterion ... stop) {
        ((Solver)this.ref()).getModel().clearObjective();
        ((Solver)this.ref()).addStopCriterion(stop);
        boolean found = ((Solver)this.ref()).solve();
        ((Solver)this.ref()).removeStopCriterion(stop);
        if (found) {
            return new Solution(((Solver)this.ref()).getModel(), new Variable[0]).record();
        }
        return null;
    }

    default public List<Solution> findAllSolutions(Criterion ... stop) {
        ((Solver)this.ref()).getModel().clearObjective();
        ((Solver)this.ref()).addStopCriterion(stop);
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        while (((Solver)this.ref()).solve()) {
            solutions.add(new Solution(((Solver)this.ref()).getModel(), new Variable[0]).record());
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
        return solutions;
    }

    default public Stream<Solution> streamSolutions(final Criterion ... stop) {
        ((Solver)this.ref()).addStopCriterion(stop);
        Spliterator<Solution> it = new Spliterator<Solution>(){

            @Override
            public boolean tryAdvance(Consumer<? super Solution> action) {
                if (((Solver)IResolutionHelper.this.ref()).solve()) {
                    action.accept(new Solution(((Solver)IResolutionHelper.this.ref()).getModel(), new Variable[0]).record());
                    return true;
                }
                ((Solver)IResolutionHelper.this.ref()).removeStopCriterion(stop);
                return false;
            }

            @Override
            public Spliterator<Solution> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 4369;
            }
        };
        return StreamSupport.stream(it, false);
    }

    default public Solution findOptimalSolution(IntVar objective, boolean maximize, Criterion ... stop) {
        ((Solver)this.ref()).getModel().setObjective(maximize, objective);
        ((Solver)this.ref()).addStopCriterion(stop);
        Solution s = new Solution(((Solver)this.ref()).getModel(), new Variable[0]);
        while (((Solver)this.ref()).solve()) {
            s.record();
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
        return ((Solver)this.ref()).isFeasible() == ESat.TRUE ? s : null;
    }

    default public List<Solution> findAllOptimalSolutions(IntVar objective, boolean maximize, Criterion ... stop) {
        ((Solver)this.ref()).addStopCriterion(stop);
        boolean defaultS = ((Solver)this.ref()).getSearch() == null;
        ((Solver)this.ref()).findOptimalSolution(objective, maximize, new Criterion[0]);
        if (!((Solver)this.ref()).isStopCriterionMet() && ((Solver)this.ref()).getSolutionCount() > 0L) {
            ((Solver)this.ref()).removeStopCriterion(stop);
            int opt = ((Solver)this.ref()).getObjectiveManager().getBestSolutionValue().intValue();
            ((Solver)this.ref()).reset();
            ((Solver)this.ref()).getModel().clearObjective();
            Constraint forceOptimal = ((Solver)this.ref()).getModel().arithm(objective, "=", opt);
            forceOptimal.post();
            if (defaultS) {
                ((Solver)this.ref()).setSearch(Search.defaultSearch(((Solver)this.ref()).getModel()));
            }
            List<Solution> solutions = this.findAllSolutions(stop);
            ((Solver)this.ref()).getModel().unpost(forceOptimal);
            return solutions;
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
        return Collections.emptyList();
    }

    default public Stream<Solution> streamOptimalSolutions(IntVar objective, boolean maximize, final Criterion ... stop) {
        ((Solver)this.ref()).addStopCriterion(stop);
        boolean defaultS = ((Solver)this.ref()).getSearch() == null;
        ((Solver)this.ref()).findOptimalSolution(objective, maximize, new Criterion[0]);
        if (!((Solver)this.ref()).isStopCriterionMet() && ((Solver)this.ref()).getSolutionCount() > 0L) {
            ((Solver)this.ref()).removeStopCriterion(stop);
            int opt = ((Solver)this.ref()).getObjectiveManager().getBestSolutionValue().intValue();
            ((Solver)this.ref()).reset();
            ((Solver)this.ref()).getModel().clearObjective();
            final Constraint forceOptimal = ((Solver)this.ref()).getModel().arithm(objective, "=", opt);
            forceOptimal.post();
            ((Solver)this.ref()).getModel().getEnvironment().save(() -> ((Solver)this.ref()).getModel().unpost(forceOptimal));
            if (defaultS) {
                ((Solver)this.ref()).setSearch(Search.defaultSearch(((Solver)this.ref()).getModel()));
            }
            Spliterator<Solution> it = new Spliterator<Solution>(){

                @Override
                public boolean tryAdvance(Consumer<? super Solution> action) {
                    if (((Solver)IResolutionHelper.this.ref()).solve()) {
                        action.accept(new Solution(((Solver)IResolutionHelper.this.ref()).getModel(), new Variable[0]).record());
                        return true;
                    }
                    ((Solver)IResolutionHelper.this.ref()).getModel().unpost(forceOptimal);
                    ((Solver)IResolutionHelper.this.ref()).removeStopCriterion(stop);
                    return false;
                }

                @Override
                public Spliterator<Solution> trySplit() {
                    return null;
                }

                @Override
                public long estimateSize() {
                    return Long.MAX_VALUE;
                }

                @Override
                public int characteristics() {
                    return 4369;
                }
            };
            return StreamSupport.stream(it, false);
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
        return Stream.empty();
    }

    default public List<Solution> findParetoFront(IntVar[] objectives, boolean maximize, Criterion ... stop) {
        ((Solver)this.ref()).addStopCriterion(stop);
        ParetoMaximizer pareto = new ParetoMaximizer((IntVar[])Stream.of(objectives).map(o -> maximize ? o : ((Solver)this.ref()).getModel().intMinusView((IntVar)o)).toArray(IntVar[]::new));
        Constraint c = new Constraint("PARETO", pareto);
        c.post();
        while (((Solver)this.ref()).solve()) {
            pareto.onSolution();
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
        ((Solver)this.ref()).getModel().unpost(c);
        return pareto.getParetoFront();
    }

    default public Solution findLexOptimalSolution(IntVar[] objectives, boolean maximize, Criterion ... stop) {
        if (objectives == null || objectives.length == 0) {
            return this.findSolution(stop);
        }
        ((Solver)this.ref()).addStopCriterion(stop);
        Solution sol = null;
        Constraint clint = null;
        UpdatablePropagator plint = null;
        IntVar[] mobj = new IntVar[objectives.length];
        for (int i = 0; i < objectives.length; ++i) {
            mobj[i] = maximize ? ((Solver)this.ref()).getModel().intMinusView(objectives[i]) : objectives[i];
        }
        while (((Solver)this.ref()).solve()) {
            if (sol == null) {
                sol = new Solution(((Solver)this.ref()).getModel(), new Variable[0]);
            }
            sol.record();
            int[] bestFound = new int[objectives.length];
            for (int vIdx = 0; vIdx < objectives.length; ++vIdx) {
                bestFound[vIdx] = sol.getIntVal(objectives[vIdx]) * (maximize ? -1 : 1);
            }
            if (plint != null) {
                plint.update(bestFound, true);
                continue;
            }
            plint = new PropLexInt(mobj, bestFound, true);
            clint = new Constraint("lex objectives", (Propagator)((Object)plint));
            clint.post();
        }
        if (clint != null) {
            ((Solver)this.ref()).getModel().unpost(clint);
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
        return sol;
    }

    default public boolean findOptimalSolutionWithBounds(IntVar bounded, Supplier<int[]> bounder, BiFunction<int[], int[], int[]> boundsRelaxer, Criterion limitPerAttempt, IntPredicate stopCriterion, Runnable onSolution) {
        int objective;
        if (!((Solver)this.ref()).getObjectiveManager().isOptimization()) {
            return false;
        }
        int[] initBounds = new int[]{bounded.getLB(), bounded.getUB()};
        IntIterableRangeSet interval = new IntIterableRangeSet(initBounds[0], initBounds[1]);
        Member cut = new Member(bounded, interval);
        UpdatablePropagator prop = (UpdatablePropagator)((Object)cut.getPropagator(0));
        IntIterableRangeSet oppinterval = interval.duplicate();
        oppinterval.flip(initBounds[0] - 1, initBounds[1] + 1);
        NotMember oppcut = new NotMember(bounded, oppinterval);
        UpdatablePropagator oppprop = (UpdatablePropagator)((Object)oppcut.getPropagator(0));
        cut.post();
        oppcut.post();
        boolean found = false;
        int[] bounds = initBounds;
        int run = 0;
        do {
            ++run;
            ((Solver)this.ref()).limitSearch(limitPerAttempt);
            while (((Solver)this.ref()).solve()) {
                bounds = bounder.get();
                interval.retainBetween(bounds[0], bounds[1]);
                prop.update(interval, true);
                onSolution.run();
                found = true;
            }
            objective = ((Solver)this.ref()).getObjectiveManager().getBestSolutionValue().intValue();
            oppinterval.addAll(interval);
            oppprop.update(oppinterval, false);
            ((Solver)this.ref()).reset();
            ((Solver)this.ref()).getObjectiveManager().updateBestSolution(objective);
            bounds = boundsRelaxer.apply(initBounds, bounds);
            interval.clear();
            interval.addBetween(bounds[0], bounds[1]);
            prop.update(interval, false);
        } while (!stopCriterion.test(run));
        ((Solver)this.ref()).reset();
        ((Solver)this.ref()).getModel().unpost(cut);
        ((Solver)this.ref()).getModel().unpost(oppcut);
        ((Solver)this.ref()).getObjectiveManager().updateBestSolution(objective);
        return found;
    }

    default public void eachSolutionWithMeasure(BiConsumer<Solution, IMeasures> cons, Criterion ... stop) {
        ((Solver)this.ref()).addStopCriterion(stop);
        Solution s = new Solution(((Solver)this.ref()).getModel(), new Variable[0]);
        while (((Solver)this.ref()).solve()) {
            cons.accept(s.record(), ((Solver)this.ref()).getMeasures());
        }
        ((Solver)this.ref()).removeStopCriterion(stop);
    }
}

