% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_eurostat_cache.R
\name{put_eurostat_cache}
\alias{put_eurostat_cache}
\title{Put an object to cache}
\usage{
put_eurostat_cache(obj, oname, update_cache = FALSE, cache_dir = NULL,
  compress_file = TRUE)
}
\arguments{
\item{obj}{an object (toc, dataset, DSD)}

\item{oname}{a character string with the name of the object to reference later in the cache}

\item{update_cache}{a logical with a default value \code{FALSE}, whether to update the cache. In this case the existing value in the cache is overwritten.  Can be set also with \code{options(restatapi_update = TRUE)}}

\item{cache_dir}{a path to a cache directory. The default is \code{NULL}, in this case the object is saved in the memory (in the '.restatapi_env'). Otherwise if the \code{cache_dir} directory does not exist it saves in the 'restatapi' directory under the temporary directory from \code{tempdir()}. Directory can also be set with \code{options(restatapi_cache_dir=...)}.}

\item{compress_file}{a logical whether to compress the RDS-file in caching. Default is \code{TRUE}.}
}
\value{
The function returns the place where the object was cached: either it creates an the object in the memory ('.restatapi_env') or creates an RDS-file.
}
\description{
Save the object (dataset/toc/DSD) to cache
}
\details{
Saves a given object in cache. This can be the memory \code{.restatapi_env} or on the hards disk. If the given \code{cache_dir} does not exist then the file is saved in the R temp directory (\code{tempdir()}. If the file or object with the \code{oname} exists in the cache, then the object is not cached.
}
\examples{
\dontshow{
if (parallel::detectCores()<=2){
   options(restatapi_cores=1)
}else{
   options(restatapi_cores=2)
}    
options(restatapi_cache_dir=NULL)
}
dt<-data.frame(txt=c("a","b","c"),nr=c(1,2,3))
put_eurostat_cache(dt,"teszt")
get("teszt",envir=.restatapi_env)

}
