% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_initialise.R
\name{tf_initialise_model}
\alias{tf_initialise_model}
\title{Initialise model weights to a global parameter fit}
\usage{
tf_initialise_model(
  model,
  params,
  mode = c("scale", "perturb", "zero", "none")
)
}
\arguments{
\item{model}{A \code{reservr_compiled_model} obtained by \code{\link[=tf_compile_model]{tf_compile_model()}}.}

\item{params}{A list of distribution parameters compatible with \code{model}.}

\item{mode}{An initialisation mode
\describe{
\item{scale}{Initialise the biases according to \code{params} and the kernels uniform on [-0.1, 0.1] *
bias scale.}
\item{perturb}{Initialise the biases according to \code{params} and leave the kernels as is.}
\item{zero}{Initialise the biases according to \code{params} and set the kernel to zero.}
\item{none}{Don't modify the weights.}
}}
}
\value{
Invisibly \code{model} with changed weights
}
\description{
Initialises a compiled \code{reservr_keras_model} weights such that the predictions are equal to, or close to, the
distribution parameters given by \code{params}.
}
\examples{
dist <- dist_exponential()
group <- sample(c(0, 1), size = 100, replace = TRUE)
x <- dist$sample(100, with_params = list(rate = group + 1))
global_fit <- fit(dist, x)

if (keras::is_keras_available()) {
  library(keras)
  l_in <- layer_input(shape = 1L)
  mod <- tf_compile_model(
    inputs = list(l_in),
    intermediate_output = l_in,
    dist = dist,
    optimizer = optimizer_adam(),
    censoring = FALSE,
    truncation = FALSE
  )
  tf_initialise_model(mod, global_fit$params)
  fit_history <- fit(
    mod,
    x = group,
    y = x,
    epochs = 200L
  )

  predicted_means <- predict(mod, data = k_constant(c(0, 1)))
}

}
