% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{movedCache}
\alias{movedCache}
\title{Deal with moved cache issues}
\usage{
movedCache(
  new,
  old,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL)
)
}
\arguments{
\item{new}{Either the path of the new \code{cachePath} where the cache was moved or copied to, or
the new DB Table Name}

\item{old}{Optional, if there is only one table in the \code{new} cache path.
Either the path of the previous \code{cachePath} where the cache was moved or copied from, or
the old DB Table Name}

\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}
}
\description{
If a user manually copies a complete Cache folder (including the db file and rasters folder),
there are issues that must be addressed. Primarily, the db table must be renamed. Run
this function after a manual copy of a cache folder. See examples for one way to do that.
}
\examples{
tmpCache <- file.path(tempdir(), "tmpCache")
tmpdir <- file.path(tempdir(), "tmpdir")
bb <- Cache(rnorm, 1, cacheRepo = tmpCache)

# Copy all files from tmpCache to tmpdir
froms <- normPath(dir(tmpCache, recursive = TRUE, full.names = TRUE))
checkPath(file.path(tmpdir, "rasters"), create = TRUE)
checkPath(file.path(tmpdir, "cacheOutputs"), create = TRUE)
file.copy(from = froms, overwrite = TRUE,
          to = gsub(normPath(tmpCache), normPath(tmpdir), froms))

# Must use 'movedCache' to update the database table
movedCache(new = tmpdir, old = tmpCache)
bb <- Cache(rnorm, 1, cacheRepo = tmpdir) # should recover the previous call

}
