% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandColumn.R
\name{expandColumn}
\alias{expandColumn}
\title{Expand a column of vectors into one row per value of each vector.}
\usage{
expandColumn(data, colName, ..., rowidSource = NULL, rowidDest = NULL,
  idxDest = NULL,
  tempNameGenerator = makeTempNameGenerator("replyr_expandColumn"))
}
\arguments{
\item{data}{data.frame to work with.}

\item{colName}{character name of column to expand.}

\item{...}{force later arguments to be bound by name}

\item{rowidSource}{optional character name of column to take row indices from (rowidDest must be NULL to use this).}

\item{rowidDest}{optional character name of column to write row indices to (must not be an existing column name, rowidSource must be NULL to use this).}

\item{idxDest}{optional character name of column to write value indices to (must not be an existing column name).}

\item{tempNameGenerator}{temp name generator produced by cdata::makeTempNameGenerator, used to record dplyr::compute() effects.}
}
\value{
expanded data frame where each value of colName column is in a new row.
}
\description{
Similar to \code{tidyr::unnest} but lands rowids and value ids, and can work on remote data sources. Fairly expensive per-row operation, not suitable for big data.
}
\examples{


d <- data.frame(name= c('a','b'))
d$value <- list(c('x','y'),'z')
expandColumn(d, 'value',
             rowidDest= 'origRowId',
             idxDest= 'valueIndex')


}
