% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Progress.R
\name{sE.progress}
\alias{sE.progress}
\title{Progress Curve for Enzyme-Catalyzed Reaction}
\usage{
sE.progress(So, time, Km, Vm, unit_S = 'mM', unit_t = 'min',
                   I = 0, Kic = Inf, Kiu = Inf, replicates = 3,
                   error = 'a', sd = 0.005, plot = TRUE)
}
\arguments{
\item{So}{initial substrate concentration.}

\item{time}{reaction timespan.}

\item{Km}{Michaelis constant.}

\item{Vm}{maximal velocity.}

\item{unit_S}{concentration unit.}

\item{unit_t}{time unit.}

\item{I}{inhibitor concentration.}

\item{Kic}{competitive inhibition constant.}

\item{Kiu}{uncompetitive inhibition constant.}

\item{replicates}{number of replicates for the dependent variable}

\item{error}{it should be one among c('absolute', 'relative').}

\item{sd}{standard deviation of the error.}

\item{plot}{logical. If TRUE, the progress curve is plotted.}
}
\value{
Returns a dataframe where the two first columns are time and St (without error). The two last columns are the mean and sd of the variable St.
}
\description{
Simulates the evolution of the substrate concentration along time.
}
\details{
When sd is different to 0, then an absolute error normally distributed is added to the variable St.
}
\examples{
sE.progress(So = 10, time = 5, Km = 4, Vm = 50, plot = FALSE)
}
\seealso{
fE.progress()
}
