% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deactivate.R
\name{deactivate}
\alias{deactivate}
\title{Deactivate a Project}
\usage{
deactivate(project = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Use \code{deactivate()} to remove the infrastructure used by \code{renv} to activate
projects for newly-launched \R sessions. In particular, this implies removing
the requisite code from the project \code{.Rprofile} that automatically activates
the project when new \R sessions are launched in the project directory.
}
\examples{
\dontrun{

# deactivate the currently-activated project
renv::deactivate()

}
}
\seealso{
Other renv: 
\code{\link{activate}()}
}
\concept{renv}
