% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_remstats.R
\name{bind_remstats}
\alias{bind_remstats}
\title{Combine two or more remstats objects}
\usage{
bind_remstats(...)
}
\arguments{
\item{...}{Any number of \code{\link{remstats}} objects. All the
\code{remstats} objects must have matching dimensions, except for the third
dimension. Note that duplicated statistics in the combined object are 
removed based on their name.}
}
\value{
\code{statistics } array with the combined statistics, where rows
refer to time points, columns refer to potential relational event (i.e.,
potential edges) in the risk set and slices refer to statistics
}
\description{
Function to bind any number of remstats objects into one while duplicated
statistics in the combined object are removed based on their name.
}
\examples{
library(remstats)

# Load the data
data(history)
data(info)

# Prepare the data
reh <- remify::remify(edgelist = history, model = "actor")

# Obtain two different statistics objects
effects1 <- ~ inertia():receive("extraversion") + otp()
stats1 <- remstats(receiver_effects = effects1, reh = reh, attr_actors = info)
effects2 <- ~ reciprocity()
stats2 <- remstats(receiver_effects = effects2, reh = reh, attr_actors = info)

# Bind the two statistics objects
statsC <- bind_remstats(stats1, stats2)

}
