% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_slopes.R
\name{nice_slopes}
\alias{nice_slopes}
\title{Easy simple slopes}
\usage{
nice_slopes(
  data,
  response,
  predictor,
  moderator,
  moderator2 = NULL,
  covariates = NULL,
  b.label,
  mod.id = TRUE,
  ci.alternative = "two.sided",
  ...
)
}
\arguments{
\item{data}{The data frame}

\item{response}{The dependent variable.}

\item{predictor}{The independent variable}

\item{moderator}{The moderating variable.}

\item{moderator2}{The second moderating variable, if applicable.}

\item{covariates}{The desired covariates in the model.}

\item{b.label}{What to rename the default "b" column
(e.g., to capital B if using standardized data for it
to be converted to the Greek beta symbol in the \code{nice_table}
function).}

\item{mod.id}{Logical. Whether to display the model number,
when there is more than one model.}

\item{ci.alternative}{Alternative for the confidence interval
of the sr2. It can be either "two.sided (the default in this
package), "greater", or "less".}

\item{...}{Further arguments to be passed to the \code{lm}
function for the models.}
}
\value{
A formatted dataframe of the simple slopes of the specified lm model,
with DV, levels of IV, degrees of freedom, regression coefficient,
t-value, p-value, and the effect size, the semi-partial correlation
squared, and its confidence interval.
}
\description{
Easily compute simple slopes in moderation analysis,
with effect sizes, and format in publication-ready format.
}
\details{
The effect size, sr2 (semi-partial correlation squared, also
known as delta R2), is computed through \link[effectsize:r2_semipartial]{effectsize::r2_semipartial}.
Please read the documentation for that function, especially regarding
the interpretation of the confidence interval. In \code{rempsyc}, instead
of using the default one-sided alternative ("greater"), we use the
two-sided alternative.
}
\examples{
# Make the basic table
nice_slopes(
  data = mtcars,
  response = "mpg",
  predictor = "gear",
  moderator = "wt"
)

# Multiple dependent variables at once
nice_slopes(
  data = mtcars,
  response = c("mpg", "disp", "hp"),
  predictor = "gear",
  moderator = "wt"
)

# Add covariates
nice_slopes(
  data = mtcars,
  response = "mpg",
  predictor = "gear",
  moderator = "wt",
  covariates = c("am", "vs")
)

# Three-way interaction (continuous moderator and binary
# second moderator required)
nice_slopes(
  data = mtcars,
  response = "mpg",
  predictor = "gear",
  moderator = "wt",
  moderator2 = "am"
)

}
\seealso{
Checking for moderation before checking simple slopes:
\code{\link{nice_mod}}, \code{\link{nice_lm}},
\code{\link{nice_lm_slopes}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/moderation}
}
\keyword{interaction}
\keyword{moderation}
\keyword{regression}
\keyword{simple}
\keyword{slopes}
