% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{subset}
\alias{[[,EotStack,ANY,ANY-method}
\alias{subset}
\alias{subset,EotStack-method}
\title{Subset modes in EotStacks}
\usage{
\S4method{subset}{EotStack}(x, subset, drop = FALSE, ...)

\S4method{[[}{EotStack,ANY,ANY}(x, i)
}
\arguments{
\item{x}{EotStack to be subset}

\item{subset}{integer or character. The modes to ectract (either by
integer or by their names)}

\item{drop}{if \code{TRUE} a single mode will be returned as an EotMode}

\item{...}{currently not used}

\item{i}{
    indices specifying elements to extract or replace.  Indices are
    \code{numeric} or \code{character} vectors or empty (missing) or
    \code{NULL}.  Numeric values are coerced to integer as by
    \code{\link{as.integer}} (and hence truncated towards zero).
    Character vectors will be matched to the \code{\link{names}} of the
    object (or for matrices/arrays, the \code{\link{dimnames}}):
    see \sQuote{Character indices} below for further details.

    For \code{[}-indexing only: \code{i}, \code{j}, \code{\dots} can be
    logical vectors, indicating elements/slices to select.  Such vectors
    are recycled if necessary to match the corresponding extent.
    \code{i}, \code{j}, \code{\dots} can also be negative integers,
    indicating elements/slices to leave out of the selection.

    When indexing arrays by \code{[} a single argument \code{i} can be a
    matrix with as many columns as there are dimensions of \code{x}; the
    result is then a vector with elements corresponding to the sets of
    indices in each row of \code{i}.

    An index value of \code{NULL} is treated as if it were \code{integer(0)}.
  }
}
\value{
an Eot* object
}
\description{
Extract a set of modes from an EotStack
}
\section{Methods (by class)}{
\itemize{
\item \code{x = EotStack,i = ANY,j = ANY}: 
}}
\examples{
data(vdendool)

nh_modes <- eot(x = vdendool, y = NULL, n = 3,
                reduce.both = FALSE, standardised = FALSE,
                verbose = TRUE)

subs <- subset(nh_modes, 2:3) # is the same as
subs <- nh_modes[[2:3]]

## effect of 'drop=FALSE' when selecting a single layer
subs <- subset(nh_modes, 2)
class(subs)
subs <- subset(nh_modes, 2, drop = TRUE)
class(subs)
}

