% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valuefunction.R
\name{makeValueFunction}
\alias{makeValueFunction}
\title{Value Function Representation}
\usage{
makeValueFunction(class, args = list(), ...)
}
\arguments{
\item{class}{[\code{character(1)}] \cr Class of value function approximation.
One of \code{c("table", "neural.network")}.}

\item{args}{[\code{list}] \cr Optional list of named arguments passed on to the
subclass. The arguments in ... take precedence over values in this list.
We strongly encourage you to use one or the other to pass arguments
to the function but not both.}

\item{...}{[\code{any}] \cr Optional named arguments passed on to the subclass. Alternatively
these can be given using the \code{args} argument.}
}
\value{
[\code{list(name, args)}] List with the name and optional args.
This list can then be passed onto \link{makeAgent}, which will construct the
value function accordingly.
}
\description{
A representation of the value function.
}
\section{Representations}{

\itemize{
\item \link{ValueTable}
\item \link{ValueNetwork}
}
}

\examples{
val = makeValueFunction("table", n.states = 16L, n.actions = 4L)
# If the number of states and actions is not supplied, the agent will try
# to figure these out from the environment object during interaction.
val = makeValueFunction("table")
}
