% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recast.R
\name{recast}
\alias{recast}
\title{Rearanjează clasele indicate oră de oră pe liniile profesorilor
(și cuplajelor) într-o matrice-orar (păstrând unicitatea claselor pe
coloanele orare și când este cazul, respectând alocarea pe ore existentă
pentru lecțiile tuplate), astfel încât numărul total de ferestre (incluzând
pe cele induse de cuplaje) să devină după un anumit număr de iterații,
cât se poate de mic.}
\usage{
recast(matPr, TPL = NULL, Niter = 3000, GD = 2)
}
\arguments{
\item{matPr}{Matricea-orar furnizată de către utilizator; liniile
sunt numite după profesori/cuplaje; pe fiecare linie sunt înregistrate
pe ore clasele la care intră profesorul (sau '-' dacă este liber);
fiecare clasă apare o singură dată, pe fiecare coloană de rang mai mic
sau egal cu numărul de ore/zi al acelei clase.}

\item{TPL}{setul tuplajelor (dacă este cazul); în matricea-orar lecțiile
dintr-un același tuplaj apar în câte o aceeași coloană orară (iar
'recast()' va păstra alocările existente pentru lecțiile tuplate).}

\item{Niter}{numărul de iterații pentru căutarea unui orar "mai bun".}

\item{GD}{un număr ideal de ferestre, pentru a stopa căutarea.}
}
\value{
o matrice-orar cu aceleași lecții ca în orarul inițial, dar
realocate pe orele 1:7 astfel încât numărul total de ferestre este
de regulă mai mic ca inițial (cât de mic, depinde și de cât de mare
este 'Niter' și mai depinde și de structura tuplajelor).
}
\description{
"programul principal" (exportat) este 'recast()', dar acesta are
în interior 6 funcții care, folosind variabilele definite în
programul principal (precum și o listă internă de "mutări corectoare"),
acționează pe matricea-orar corespunzătoare iterației curente,
pe parcursul căutării unui orar "mai bun" (cu mai puține ferestre).
}
\examples{
# Alegem 'Niter' mic, pentru o execuție rapidă
ORR <- recast(MOZ, TPL, Niter=100)
HG <- have_gaps(ORR[[1]])
}
