% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probs.icar.R
\name{probs.icar}
\alias{probs.icar}
\title{OLM and ICAR model probabilities for areal data}
\usage{
probs.icar(
  Y,
  X,
  H,
  H.spectral = NULL,
  Sig_phi = NULL,
  b = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{Y}{A vector of responses.}

\item{X}{A matrix of covariates, which should include a column of 1's for models with a non-zero intercept}

\item{H}{Neighborhood matrix for spatial subregions.}

\item{H.spectral}{Spectral decomposition of neighborhood matrix, if user wants to pre-compute it to save time.}

\item{Sig_phi}{Pseudo inverse of the neighborhood matrix, if user wants to pre-compute it to save time.}

\item{b}{Training fraction for the fractional Bayes factor (FBF) approach.}

\item{verbose}{If FALSE, marginal likelihood progress is not printed.}
}
\value{
A list containing a data frame with all posterior model probabilities and other selection information.
\item{probs.mat}{Data frame containing posterior model probabilities for all candidate OLMs and ICAR models from the data.}
\item{mod.prior}{Vector of model priors used to obtain the posterior model probabilities.}
\item{logmargin.all}{Vector of all (log) fractional integrated likelihoods.}
\item{base.model}{Maximum (log) fractional integrated likelihood among all candidate models.  All fractional Bayes factors are obtained with respect to this model.}
\item{BF.vec}{Vector of fractional Bayes factors for all candidate models.}
}
\description{
Performs simultaneous selection of covariates and spatial model structure for areal data.
}
\references{
\insertRef{Porter_2023}{ref.ICAR}
}
\author{
Erica M. Porter, Christopher T. Franck, and Marco A.R. Ferreira
}
