% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridUncertainty_functions.R
\name{gridUncertaintyBase}
\alias{gridUncertaintyBase}
\title{Base function to compute AOO with grid uncertainty systematically}
\usage{
gridUncertaintyBase(ecosystem.data, grid.size, splits,
  min.percent.rule = TRUE, percent = 1)
}
\arguments{
\item{ecosystem.data}{Raster object of an ecosystem or species distribution.
Please use a CRS with units measured in metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}

\item{splits}{Specifies the number of ways to split the grid in ONE axis.}

\item{min.percent.rule}{Logical. If \code{TRUE}, a minimum area threshold
must be passed before a grid is counted as an AOO grid.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}.}
}
\value{
List containing the following:
\itemize{
 \item Vector of length split*split of calculated AOO for each shifted grid
 \item Data frame of summary statistics for the results
 create the AOO grid(s) which return the smallest AOO
 \item Data frame of the shift(s) required to create the AOO grid(s) with the
 smallest AOO
}
}
\description{
\code{gridUncertaintyBase} helps determine the minimum number of area of
occupancy (AOO) grid cells occupied by a species or ecosystem. It varies the
location of the AOO grid by shifting in systematically in both x- and y-
axes, adding a small amount of random movement (five percent of the
\code{grid.size}) at each point. It then returns summary statistics for the
range of AOOs calculated, and the RasterLayer(s) containing the grids with
the minimum AOO. It is the base function which is used by
\code{gridUncertainty} and \code{gridUncertaintySimulation}
}
\references{
Bland, L.M., Keith, D.A., Miller, R.M., Murray, N.J. and
  Rodriguez, J.P. (eds.) 2016. Guidelines for the application of IUCN Red
  List of Ecosystems Categories and Criteria, Version 1.0. Gland,
  Switzerland: IUCN. ix + 94pp. Available at the following web site:
  \url{iucnrle.org/}
}
\seealso{
\code{\link{createGrid}} \code{\link{getAOOSilent}}

Other gridUncertainty functions: \code{\link{gridUncertaintyRandomManual}},
  \code{\link{gridUncertaintyRandom}},
  \code{\link{gridUncertaintySimulation}},
  \code{\link{gridUncertainty}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
