plans <- plans_10[, 1:2]

test_that('compactness works', {
  capture.output(
  comp <- redist.compactness(
    shp = fl25, plans = plans,
    measure = 'all', total_pop = pop, planarize = FALSE,
    counties = rep(1, 25))
  )
  expected <- structure(list(district = c(1L, 2L, 3L, 1L, 2L, 3L), PolsbyPopper = c(
      0.28558422246899, 0.245854953175331, 0.336597469649693,
      0.397400056760609, 0.245854953175331, 0.234731346396897
  ), Schwartzberg = c(
      1.87125465941381, 2.01678925492167, 1.7236321119282,
      1.5863026056347, 2.01678925492167, 2.06402263227669
  ), LengthWidth = c(
    0.926285160038819, 0.653935724266415, 0.404149212048674,
    0.874431619447365, 0.653935724266415, 0.417276720351394
  ), ConvexHull = c(
    0.68886719971328,
    0.657283200146699, 0.696409105212057, 0.724494964993755, 0.657283200146699,
    0.598769626173265
  ), Reock = c(
    0.43437300523785, 0.306645852527558,
    0.224742497097297, 0.424640741237631, 0.306645852527558, 0.210845488809258
  ), BoyceClark = c(
    0.855392779807052, 0.750250900412383, 0.735085159873138,
    0.832201015045522, 0.750250900412383, 0.804636547547239
  ), FryerHolden = c(
      1469127189558785024, 1469127189558785024, 1469127189558785024,
      1192801089849208320, 1192801089849208320, 1192801089849208320
  ), EdgesRemoved = c(
    32,
    32, 32, 32, 32, 32
  ), FracKept = c(
    0.372549019607843, 0.372549019607843,
    0.372549019607843, 0.372549019607843, 0.372549019607843, 0.372549019607843
  ), logSpanningTree = c(
    12.6907185515128, 12.6907185515128, 12.6907185515128,
    12.6907185515128, 12.6907185515128, 12.6907185515128
  ), draw = c(
    1,
    1, 1, 2, 2, 2
  )), row.names = c(NA, -6L), class = c(
    'tbl_df',
    'tbl', 'data.frame'
  ))

  expect_equal(comp, expected, tolerance=1e-4)
})


test_that('test prep polsbypopper works', {
  test <- redist.prep.polsbypopper(shp = fl25)

  expect_s3_class(test, class = 'data.frame')
})
