% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportNextRecordName.R
\name{exportNextRecordName}
\alias{exportNextRecordName}
\alias{exportNextRecordName.redcapApiConnection}
\title{Generate Next Record Name from a REDCap Database}
\usage{
exportNextRecordName(rcon, ...)

\method{exportNextRecordName}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{...}{Arguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
Returns the maximum integer record ID + 1.
}
\description{
To be used by projects with record auto-numbering enabled, 
this method exports the next potential record ID for a project.
}
\details{
It generates the next record name by determining the current maximum numerical 
record ID and then incrementing it by one.
}
\section{REDCap API Documentation}{


NOTE: This method does not create a new record, but merely determines 
what the next record name would be.
}

\section{REDCap Version}{

8.1.8+
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Xuefei Jia
}
