% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportEvents.R
\name{exportEvents}
\alias{exportEvents}
\alias{exportEvents.redcapApiConnection}
\title{Export the Events for a Project}
\usage{
exportEvents(rcon, ...)

\method{exportEvents}{redcapApiConnection}(
  rcon,
  arms = NULL,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{...}{Arguments to be passed to other methods.}

\item{arms}{A numeric vector or arm numbers to retrieve. Will also accept
a character vector, but will coerce to numeric before processing.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
Returns a data frame with six columns
\itemize{
  \item{\code{event_name} }{The desciptive name of the event.}
  \item{\code{arm_num} }{The arm number in which the event occurs.}
  \item{\code{day_offset} }{The days offset from the first event.}
  \item{\code{offset_min} }{The minimum offset value.}
  \item{\code{offset_max} }{The maximium offset value.}
  \item{\code{unique_event_name} }{A unique event identifying name.}
}
}
\description{
Retrieve a data frame giving the users, expiration dates,
and data access privileges for each user.
}
\details{
It is not sufficient to make the project a longitudinal project. The
project must satisfy one of two conditions: 1) have at least two arms and
one event defined; or 2) have one arm and at least two events defined. If 
neither of these conditions are satisfied, the API will return a message
such as \code{ERROR: You cannot export arms for classic projects}, an 
error message that isn't as descriptive of the nature of the problem as 
we might like.

If the project information reports that the project is not longitudinal, 
a data frame with 0 rows is returned without calling the API.
}
\section{REDCap API Documentation}{

This function allows you to export the events for a project

NOTE: this only works for longitudinal projects.
}

\section{REDCap Version}{

5.8.2+
}

\section{Known REDCap Limitations}{

None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
