% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRecords.R
\name{importRecords}
\alias{importRecords}
\alias{importRecords.redcapApiConnection}
\title{Import Records to a REDCap Database}
\usage{
importRecords(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing"),
  returnData = FALSE,
  logfile = "",
  ...
)

\method{importRecords}{redcapApiConnection}(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing"),
  returnData = FALSE,
  logfile = "",
  ...,
  bundle = NULL,
  batch.size = -1
)
}
\arguments{
\item{rcon}{A REDCap connection object as created by \code{redcapConnection}.}

\item{data}{A \code{data.frame} to be imported to the REDCap project.}

\item{overwriteBehavior}{Character string.  'normal' prevents blank
fields from overwriting populated fields.  'overwrite' causes blanks to
overwrite data in the REDCap database.}

\item{returnContent}{Character string.  'count' returns the number of
records imported; 'ids' returns the record ids that are imported;
'nothing' returns no message.}

\item{returnData}{Logical.  Prevents the REDCap import and instead
returns the data frame that would have been given
for import.  This is sometimes helpful if the API import fails without
providing an informative message. The data frame can be written to a csv
and uploaded using the interactive tools to troubleshoot the
problem.  Please shoot me an e-mail if you find errors I havne't
accounted for.}

\item{logfile}{An optional filepath (preferably .txt) in which to print the
log of errors and warnings about the data.
If \code{""}, the log is printed to the console.}

\item{...}{Arguments to be passed to other methods.}

\item{bundle}{A \code{redcapBundle} object as created by
\code{exportBundle}.}

\item{batch.size}{Specifies size of batches.  A negative value
indicates no batching.}
}
\description{
Imports records from a \code{data.frame} to a REDCap Database
}
\details{
A record of imports through the API is recorded in the Logging section
of the project.

\code{importRecords} prevents the most common import errors by testing the
data before attempting the import.  Namely
\enumerate{
  \item Check that all variables in \code{data} exist in the REDCap data dictionary.
  \item Check that the study id variable exists
  \item Force the study id variable to the first position in the data frame (with a warning)
  \item Remove calculated fields (with a warning)
  \item Verify that REDCap date fields are represented in the data frame as
    either character, POSIXct, or Date class objects.
  \item Determine if values are within their specified validation limits.
}

See the documentation for \code{\link{validateImport}} for detailed
explanations of the validation.
}
\section{Limitations}{


The REDCap API is fairly restrictive about what it will accept as valid data for import. 
\code{importRecords} tries to simplify the process by allowing users to 
submit data in any form recognized by the data dictionary. It is then converted
internally to the 
appropriate text format for import. This means, for example, that a radio button value
where the code \code{1} is mapped to the label \code{Guitar} (defined in the user interface
with "1, Guitar"), the user can provide
either "1" or "Guitar" as a value and \code{importRecords} will translate it to the 
code that the API expects. 

While this provides a level of convenience for the user, it has some limitations when
applied to checkbox values. When submitting checkbox values for import, it is strongly 
recommended that you submit either the code "0" (for unchecked), "1" (for checked), or the 
labels "Unchecked" and "Checked". 

In particular, when the checkbox labels are defined with a code or label that is "0" or "1"
(for example, "0, checkbox_label" or "check_code, 0"), \code{importRecords} is unable to 
determine if a 0 indicates an unchecked box or if the zero is the label of a checked box. 
When encountering ambiguity, \code{importRecords} will always assume "0" represents an
unchecked box and "1" represents a checked box.
}

\references{
See the REDCap API documentation at your institution's REDCap documentation.
}
\seealso{
\code{\link{validateImport}}
}
\author{
Benjamin Nutter\cr
with thanks to Josh O'Brien and etb (see references)
}
