% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportVersion.R
\name{exportVersion}
\alias{exportVersion}
\alias{exportVersion.redcapApiConnection}
\title{Export the REDCap Version Number}
\usage{
exportVersion(rcon, ...)

\method{exportVersion}{redcapApiConnection}(rcon, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{...}{Arguments to pass to other methods}
}
\value{
Returns a character value giving the version number.

IF this function is used in a version of REDCap that does not support
the method (prior to version 6.0.0), the value "5.12.2" will be returned.
This is done solely for the convenience of always returning a value
that can be compared against other versions.
}
\description{
These methods enable the user to export the REDCap instance
version number.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export the version number
exportVersion(rcon)
}

}
