% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clean_rows.R
\name{get_failed_tests}
\alias{get_failed_tests}
\title{Get Failed Tests}
\usage{
get_failed_tests(playback, ignore_tests = NULL, ignore_cols = NULL,
  ignore_combinations = NULL)
}
\arguments{
\item{playback}{\code{data.playback} to extract failed tests from.}

\item{ignore_tests}{\code{character} ignore test results from tests with 
these names.}

\item{ignore_cols}{\code{character} ignore test results from tests of 
columns with these names.}

\item{ignore_combinations}{\code{list} ignore test results from specific 
tests of specific columns.}
}
\value{
\code{data.table} with test results as logicals for all of the tests
with at least one failure. A failed test for any given row is 
equivalent to a value of TRUE. If all tests passed, the function will simply 
return a data.table with one column, 'any_failures', that is always FALSE, 
to ensure that the output is (type) stable and consistent.
}
\description{
Get Failed Tests
}
\examples{
# record tape from `iris`.
tape <- record(iris)
# load data.
data(iris_newdata)
# validate new data by playing new tape on it.
playback <- play(tape, iris_newdata)

get_failed_tests(playback)
get_failed_tests(playback, ignore_tests = "outside_range")
get_failed_tests(playback, ignore_cols = "junk")
get_failed_tests(playback, ignore_combinations = list(outside_range = "Sepal.Width"))
}
