% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_score_simple.R, R/score_simple.R
\name{score_simple.cluster_pairs}
\alias{score_simple.cluster_pairs}
\alias{score_simple}
\alias{score_simple.pairs}
\title{Score pairs based on a number of comparison vectors}
\usage{
\method{score_simple}{cluster_pairs}(
  pairs,
  variable,
  on,
  w1 = 1,
  w0 = 0,
  wna = 0,
  new_name = NULL,
  ...
)

score_simple(pairs, variable, on, w1 = 1, w0 = 0, wna = 0, ...)

\method{score_simple}{pairs}(
  pairs,
  variable,
  on,
  w1 = 1,
  w0 = 0,
  wna = 0,
  inplace = FALSE,
  ...
)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{variable}{the name of the new variable to create in pairs. This will be a
logical variable with a value of \code{TRUE} for the selected pairs.}

\item{on}{character vector of variables on which the score should be based.}

\item{w1}{a vector or list with weights for agreement for each of the
variables. It can either be a numeric vector of length 1 in which case the
same weight is used for all variables; A numeric vector of length equal to
the length of \code{on} in which case the weights correspond one-to-one to
the variables in \code{on}; A named numeric vector where the names
correspond to those in \code{on}, missing values are assigned a value of 1;
or a named list with numeric values.  See details for more information.}

\item{w0}{a vector or list with weights for non-agreement for each of the
variables. See details for more information. For the format see \code{w1}.}

\item{wna}{a vector or list with weights for agreement for each of the
variables. See details for more information. For the format see \code{w1}.}

\item{new_name}{name of new object to assign the pairs to on the cluster
nodes.}

\item{...}{ignored}

\item{inplace}{logical indicating whether \code{pairs} should be modified in place. When
pairs is large this can be more efficient.}
}
\value{
Returns the \code{data.table} \code{pairs} with the column \code{variable} added in
case of \code{score_simple.pairs}. 

In case of \code{score_simple.cluster_pairs}, \code{score_simple.pairs} is called on
each cluster node and the resulting pairs are assigned to \code{new_name} in
the environment \code{reclin_env}. When \code{new_name} is not given (or
equal to NULL) the original pairs on the nodes are overwritten.
}
\description{
Score pairs based on a number of comparison vectors
}
\details{
The individual contribution of a variable \code{x} to the total score is
given by \code{x * w1 + (1-x) * w0} in case of non-\code{NA} values and
\code{wna} in case of \code{NA}. This assumes that the values 1 corresponds
to complete agreement and the value 0 to complete non-agreement. In case of
complete agreement a variable contributes \code{w1} to the total score and in
case of complete non-agreement it contributes \code{w0} to the total score.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
compare_pairs(pairs, on = c("firstname", "lastname", "sex"), inplace = TRUE)

score_simple(pairs, "score", on = c("firstname", "lastname", "sex"))

# Change the default weights
score_simple(pairs, "score", on = c("firstname", "lastname", "sex"), 
  w1 = 2, w0 = -1, wna = NA)

# Use a named vector; omited elements from w1 get a weight of 1; those from
# w0 and wna a weight of 0.
score_simple(pairs, "score", on = c("firstname", "lastname", "sex"), 
  w1 = c("firstname" = 2, "lastname" = 3), 
  w0 = c("firstname" = -1, "lastname" = -0.5))

# Use a named list; omited elements from w1 get a weight of 1; those from
# w0 and wna a weight of 0.
score_simple(pairs, "score", on = c("firstname", "lastname", "sex"), 
  w1 = list("firstname" = 2, "lastname" = 3), 
  w0 = list("firstname" = -1, "lastname" = -0.5))

}
