% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsevctrs.R
\name{sparse_data}
\alias{sparse_data}
\title{Using sparse data with recipes}
\description{
\code{\link[=recipe]{recipe()}}, \code{\link[=prep]{prep()}}, and \code{\link[=bake]{bake()}} all accept sparse tibbles from the
\code{sparsevctrs} package and sparse matrices from the \code{Matrix} package. Sparse
matrices are converted to sparse tibbles internally as each step expects a
tibble as its input, and is expected to return a tibble as well.
}
\details{
Several steps work with sparse data. A step can either work with sparse
data, ruin sparsity, or create sparsity. The documentation for each step
will indicate whether it will work with sparse data or create sparse columns.
If nothing is listed it is assumed to ruin sparsity.

Sparse tibbles or \code{data.frame}s will be returned from \code{\link[=bake]{bake()}} if sparse columns
are present in data, either from being generated in steps or because sparse
data was passed into \code{\link[=recipe]{recipe()}}, \code{\link[=prep]{prep()}}, or \code{\link[=bake]{bake()}}.
}
