% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxCox.R
\name{step_BoxCox}
\alias{step_BoxCox}
\title{Box-Cox Transformation for Non-Negative Data}
\usage{
step_BoxCox(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  lambdas = NULL,
  limits = c(-5, 5),
  num_unique = 5,
  skip = FALSE,
  id = rand_id("BoxCox")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{lambdas}{A numeric vector of transformation values. This
is \code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{limits}{A length 2 numeric vector defining the range to
compute the transformation parameter lambda.}

\item{num_unique}{An integer to specify minimum required unique
values to evaluate for a transformation.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_BoxCox} creates a \emph{specification} of a recipe
step that will transform data using a simple Box-Cox
transformation.
}
\details{
The Box-Cox transformation, which requires a strictly
positive variable, can be used to rescale a variable to be more
similar to a normal distribution. In this package, the partial
log-likelihood function is directly optimized within a
reasonable set of transformation values (which can be changed by
the user).

This transformation is typically done on the outcome variable
using the residuals for a statistical model (such as ordinary
least squares). Here, a simple null model (intercept only) is
used to apply the transformation to the \emph{predictor}
variables individually. This can have the effect of making the
variable distributions more symmetric.

If the transformation parameters are estimated to be very
closed to the bounds, or if the optimization fails, a value of
\code{NA} is used and no transformation is applied.

When you \code{\link[=tidy]{tidy()}} this step, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{value} (the
lambda estimate) is returned.
}
\examples{

rec <- recipe(~ ., data = as.data.frame(state.x77))

bc_trans <- step_BoxCox(rec, all_numeric())

bc_estimates <- prep(bc_trans, training = as.data.frame(state.x77))

bc_data <- bake(bc_estimates, as.data.frame(state.x77))

plot(density(state.x77[, "Illiteracy"]), main = "before")
plot(density(bc_data$Illiteracy), main = "after")

tidy(bc_trans, number = 1)
tidy(bc_estimates, number = 1)
}
\references{
Sakia, R. M. (1992). The Box-Cox transformation technique:
A review. \emph{The Statistician}, 169-178..
}
\seealso{
Other individual transformation steps: 
\code{\link{step_YeoJohnson}()},
\code{\link{step_bs}()},
\code{\link{step_harmonic}()},
\code{\link{step_hyperbolic}()},
\code{\link{step_inverse}()},
\code{\link{step_invlogit}()},
\code{\link{step_logit}()},
\code{\link{step_log}()},
\code{\link{step_mutate}()},
\code{\link{step_ns}()},
\code{\link{step_poly}()},
\code{\link{step_relu}()},
\code{\link{step_sqrt}()}
}
\concept{individual transformation steps}
