% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollimpute.R
\name{step_rollimpute}
\alias{step_rollimpute}
\alias{tidy.step_rollimpute}
\title{Impute Numeric Data Using a Rolling Window Statistic}
\usage{
step_rollimpute(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  statistic = median,
  window = 5,
  skip = FALSE,
  id = rand_id("rollimpute")
)

\method{tidy}{step_rollimpute}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}} for more
details. These columns should be non-integer numerics (i.e.,
double precision). For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A named numeric vector of columns. This is
\code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{statistic}{A function with a single argument for the data to compute
the imputed value. Only complete values will be passed to the function and
it should return a double precision value.}

\item{window}{The size of the window around a point to be imputed. Should be
an odd integer greater than one. See Details below for a discussion of
points at the ends of the series.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_rollimpute} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{window} (the window size).
}
\description{
\code{step_rollimpute} creates a \emph{specification} of a
recipe step that will substitute missing values of numeric
variables by the a measure of location (e.g. median) within a moving window.
}
\details{
On the tails, the window is shifted towards the ends.
For example, for a 5-point window, the windows for the first
four points are \code{1:5}, \code{1:5}, \code{1:5}, and then \code{2:6}.

When missing data are in the window, they are not passed to the
function. If all of the data in the window are missing, a
missing value is returned.

The statistics are calculated on the training set values
\emph{before} imputation. This means that if previous data within the
window are missing, their imputed values are not included in the
window data used for imputation. In other words, each imputation
does not know anything about previous imputations in the series
prior to the current point.
}
\examples{
library(lubridate)

set.seed(145)
example_data <-
  data.frame(
    day = ymd("2012-06-07") + days(1:12),
    x1 = round(runif(12), 2),
    x2 = round(runif(12), 2),
    x3 = round(runif(12), 2)
  )
example_data$x1[c(1, 5, 6)] <- NA
example_data$x2[c(1:4, 10)] <- NA

library(recipes)
seven_pt <- recipe(~ . , data = example_data) \%>\%
  update_role(day, new_role = "time_index") \%>\%
  step_rollimpute(all_predictors(), window = 7) \%>\%
  prep(training = example_data)

juice(seven_pt)
}
\concept{imputation}
\concept{preprocessing}
\keyword{datagen}
