\name{make.case.control.study}
\alias{make.case.control.study}

\title{
  Construct a case-control-study data frame.
}

\description{
  Is used for combining a PopulationAtRisk object and a data frame of
  cases and a data frame of controls to a CaseControlStudy object.
  Usually not needed to call directly. Is used by \code{\link{rccs}}.
}

\usage{
make.case.control.study(PaR, cases, controls)
}

\arguments{
  \item{PaR}{
    A \code{PopulationAtRisk} object as generated by \code{\link{build.population}}.
  }
  \item{cases}{
    A data frame of cases as generated by \code{\link{make.cases}}.
  }
  \item{controls}{
    A data frame of controls as generated by \code{\link{make.controls}}.
  }
}



\author{
  Christian Westphal
}

\seealso{
  \code{\link{make.cases}}, \code{\link{make.controls}},
  \code{\link{rccs}}
}

\examples{
## Set up the population:
PaR <- build.population( cancer ~ smoking + drinking, 5000000, .0001,
c(.2,.2,.1), c(2,5,10) )

## Generate random cases:
my.cases <- make.cases( PaR, TRUE )

## Generate random controls:
my.controls <- make.controls( PaR, my.cases, 5, TRUE )

## Combine all three objects in a CaseControlStudy object
ccs <- make.case.control.study( PaR, my.cases, my.controls )

summary(ccs)
}

\keyword{ datagen }

