% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{degrees_to_radians}
\alias{degrees_to_radians}
\alias{radians_to_degrees}
\title{Conversion between radians and degrees}
\usage{
degrees_to_radians(degrees)

radians_to_degrees(radians)
}
\arguments{
\item{degrees}{\code{vector} of degrees to convert to radians with \deqn{`degrees` * (\pi / 180)}}

\item{radians}{\code{vector} of radians to convert to degrees with \deqn{`radians` / (\pi / 180)}}
}
\value{
\code{vector} with converted degrees/radians.

Missing values (\code{NA}s) are returned as they are.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Convert degrees to radians or radians to degrees.
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Degrees to radians
degrees_to_radians(c(90, 180, 270))

# Radians to degrees
radians_to_degrees(c(pi / 2, pi, 1.5 * pi))

# Get back the original degrees
radians_to_degrees(degrees_to_radians(c(90, 180, 270)))
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
