% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-sheets.R
\name{excel_sheets}
\alias{excel_sheets}
\title{List all sheets in an excel spreadsheet}
\usage{
excel_sheets(path)
}
\arguments{
\item{path}{Path to the xls/xlsx file.}
}
\description{
The list of sheet names is especially useful when you want to iterate over
all of the sheets in a workbook. The \code{vignette("readxl-workflows")} article
provides several worked examples of this, showing how to combine readxl with
other packages in the tidyverse, such as purrr, or with base R functions like
\code{\link[=lapply]{lapply()}}.
}
\examples{
excel_sheets(readxl_example("datasets.xlsx"))
excel_sheets(readxl_example("datasets.xls"))

# To load all sheets in a workbook, use lapply()
path <- readxl_example("datasets.xls")
lapply(excel_sheets(path), read_excel, path = path)
}
