% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{rws_write}
\alias{rws_write}
\alias{rws_write_sqlite}
\title{Write to a SQLite Database}
\usage{
rws_write(
  x,
  exists = TRUE,
  delete = FALSE,
  replace = FALSE,
  meta = TRUE,
  log = TRUE,
  commit = TRUE,
  strict = TRUE,
  x_name = substitute(x),
  silent = getOption("rws.silent", FALSE),
  conn,
  ...
)
}
\arguments{
\item{x}{The object to write.}

\item{exists}{A flag specifying whether the table(s) must already exist.}

\item{delete}{A flag specifying whether to delete existing rows before
inserting data. If \code{meta = TRUE} the meta data is deleted.}

\item{replace}{A flag specifying whether to replace any existing rows whose inclusion would violate unique or primary key constraints.}

\item{meta}{A flag specifying whether to preserve meta data.}

\item{log}{A flag specifying whether to log the table operations.}

\item{commit}{A flag specifying whether to commit the operations
(calling with commit = FALSE can be useful for checking data).}

\item{strict}{A flag specifying whether to error if x has extraneous columns or if exists = TRUE extraneous data frames.}

\item{x_name}{A string of the name of the object.}

\item{silent}{A flag specifying whether to suppress messages and warnings.}

\item{conn}{A \linkS4class{SQLiteConnection} to a database.}

\item{...}{Not used.}
}
\value{
An invisible character vector of the name(s) of the table(s).
}
\description{
Write to a SQLite Database
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_disconnect(conn)
}
\seealso{
Other rws_write: 
\code{\link{rws_write.data.frame}()},
\code{\link{rws_write.environment}()},
\code{\link{rws_write.list}()}
}
\concept{rws_write}
