% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rba_forecasts.R
\name{rba_forecasts}
\alias{rba_forecasts}
\alias{read_forecasts}
\title{Compile the RBA's public forecasts of key economic variables over time}
\usage{
rba_forecasts(
  refresh = TRUE,
  all_or_latest = c("all", "latest"),
  remove_old = TRUE
)

read_forecasts(...)
}
\arguments{
\item{refresh}{logical; default is \code{TRUE}. When set to \code{TRUE}, up-to-date
forecasts will be downloaded from the RBA's website. When \code{FALSE}, only
the package's internal data will be returned, which may be out of date.}

\item{all_or_latest}{character; default is \code{"all"}. When \code{"all"} is specified,
all publicly-available forecasts will be returned; when \code{"latest"}, only the
latest forecasts will be used.}

\item{remove_old}{logical; default is \code{TRUE}. When \code{TRUE}, any observations
for which the \code{date} is more than 180 days prior to the \code{forecast_date}
is excluded.}

\item{...}{Arguments passed to \code{rba_forecasts()}}
}
\value{
A tidy \code{tbl_df} containing 8 columns:
\describe{
\item{\code{forecast_date}}{ The (approximate) date on which the forecast was published. Note that this is the first day of the publication month, so the \code{forecast_date} for forecasts in the February 2020 Statement on Monetary Policy is \code{as.Date("2020-02-01")}.}
\item{\code{date}}{ The date to which the forecast pertains. Note that this is the first day of the final month of the relevant quarter. For example, a forecast of GDP in the June quarter 2021 will be \code{as.Date("2021-06-01")}.}
\item{\code{year_qtr}}{ The year and quarter to which the forecast pertains, such as 2019.1.}
\item{\code{series}}{ Short, snake_case description of the data series being forecast, such as \code{gdp_change} or \code{unemp_rate}. These are consistent over time.}
\item{\code{value}}{ The forecast value, in per cent. For example, if GDP growth is forecast to be 3 per cent, the value will be \code{3}. Note that where a forecast is given as a range (eg. 3.5-4.5\%) the \code{value} will be the midpoint of the range (eg. 4\%).}
\item{\code{series_desc}}{ Full description of the series being forecast, as per the RBA website, such as "Real household disposable income". Note that series descriptions are not necessarily consistent over time; the values here are those published by the RBA. The \code{series} column is consistent over time. }
\item{\code{source}}{ For recent forecasts, this is 'SMP', meaning the RBA's Statement on Monetary Policy. Forecasts prior to 2014 are sourced from various places; see \code{Details}. }
\item{\code{notes}}{ Notes accompanying the forecasts, as per the RBA's website. Note these are identical for item in a given \code{forecast_date}.}
}
}
\description{
Compile the RBA's public forecasts of key economic variables over time
}
\details{
Forecasts are not available for all series on all forecast dates. CPI
inflation and GDP growth are included in all forecasts. The unemployment
rate is included in most forecasts. Other series are included inconsistently,
based on their availability in the underlying source data.

All forecasts issued on or before November 2014 come from Tulip
and Wallace (2012), RBA RDP2012-07.
Data available: \url{https://www.rba.gov.au/statistics/historical-forecasts.html}.

Data from 2015 to August 2018 are scraped from the RBA's quarterly Statement on
Monetary Policy (\url{https://www.rba.gov.au/publications/smp/2020/aug/}).
Note from from Feb 2015 to August 2018 (inclusive) only include a few series;
those from November 2018 onwards include more series.

Data from November 2018 to present comes from the published 'Forecasts Archive'
file on the RBA website
(\url{https://www.rba.gov.au/publications/smp/forecasts-archive.html}).

\code{read_forecasts()} is a wrapper around \code{rba_forecasts()}.
}
\examples{
forecasts <- read_forecasts()

}
