% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.R
\name{read_rds}
\alias{read_rds}
\alias{write_rds}
\title{Read/write RDS files.}
\usage{
read_rds(path)

write_rds(x, path, compress = c("none", "gz", "bz2", "xz"), ...)
}
\arguments{
\item{path}{Path to read from/write to.}

\item{x}{R object to write to serialise.}

\item{compress}{Compression method to use: "none", "gz" ,"bz", or "xz".}

\item{...}{Additional arguments to connection function. For example, control
the space-time trade-off of different compression methods with
\code{compression}. See \code{\link[=connections]{connections()}} for more details.}
}
\value{
\code{write_rds()} returns \code{x}, invisibly.
}
\description{
Consistent wrapper around \code{\link[=saveRDS]{saveRDS()}} and \code{\link[=readRDS]{readRDS()}}.
\code{write_rds()} does not compress by default as space is generally cheaper
than time.
}
\examples{
temp <- tempfile()
write_rds(mtcars, temp)
read_rds(temp)

\dontrun{
write_rds(mtcars, "compressed_mtc.rds", "xz", compression = 9L)
}
}
\keyword{internal}
